/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloud9;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.cloud9.AWSCloud9Async;
import com.amazonaws.services.cloud9.AWSCloud9AsyncClientBuilder;
import com.amazonaws.services.cloud9.AWSCloud9Client;
import com.amazonaws.services.cloud9.model.CreateEnvironmentEC2Request;
import com.amazonaws.services.cloud9.model.CreateEnvironmentEC2Result;
import com.amazonaws.services.cloud9.model.CreateEnvironmentMembershipRequest;
import com.amazonaws.services.cloud9.model.CreateEnvironmentMembershipResult;
import com.amazonaws.services.cloud9.model.DeleteEnvironmentMembershipRequest;
import com.amazonaws.services.cloud9.model.DeleteEnvironmentMembershipResult;
import com.amazonaws.services.cloud9.model.DeleteEnvironmentRequest;
import com.amazonaws.services.cloud9.model.DeleteEnvironmentResult;
import com.amazonaws.services.cloud9.model.DescribeEnvironmentMembershipsRequest;
import com.amazonaws.services.cloud9.model.DescribeEnvironmentMembershipsResult;
import com.amazonaws.services.cloud9.model.DescribeEnvironmentStatusRequest;
import com.amazonaws.services.cloud9.model.DescribeEnvironmentStatusResult;
import com.amazonaws.services.cloud9.model.DescribeEnvironmentsRequest;
import com.amazonaws.services.cloud9.model.DescribeEnvironmentsResult;
import com.amazonaws.services.cloud9.model.ListEnvironmentsRequest;
import com.amazonaws.services.cloud9.model.ListEnvironmentsResult;
import com.amazonaws.services.cloud9.model.ListTagsForResourceRequest;
import com.amazonaws.services.cloud9.model.ListTagsForResourceResult;
import com.amazonaws.services.cloud9.model.TagResourceRequest;
import com.amazonaws.services.cloud9.model.TagResourceResult;
import com.amazonaws.services.cloud9.model.UntagResourceRequest;
import com.amazonaws.services.cloud9.model.UntagResourceResult;
import com.amazonaws.services.cloud9.model.UpdateEnvironmentMembershipRequest;
import com.amazonaws.services.cloud9.model.UpdateEnvironmentMembershipResult;
import com.amazonaws.services.cloud9.model.UpdateEnvironmentRequest;
import com.amazonaws.services.cloud9.model.UpdateEnvironmentResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSCloud9AsyncClient
extends AWSCloud9Client
implements AWSCloud9Async {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSCloud9AsyncClientBuilder asyncBuilder() {
        return AWSCloud9AsyncClientBuilder.standard();
    }

    AWSCloud9AsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateEnvironmentEC2Result> createEnvironmentEC2Async(CreateEnvironmentEC2Request request) {
        return this.createEnvironmentEC2Async(request, null);
    }

    @Override
    public Future<CreateEnvironmentEC2Result> createEnvironmentEC2Async(CreateEnvironmentEC2Request request, final AsyncHandler<CreateEnvironmentEC2Request, CreateEnvironmentEC2Result> asyncHandler) {
        final CreateEnvironmentEC2Request finalRequest = (CreateEnvironmentEC2Request)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateEnvironmentEC2Result>(){

            @Override
            public CreateEnvironmentEC2Result call() throws Exception {
                CreateEnvironmentEC2Result result = null;
                try {
                    result = AWSCloud9AsyncClient.this.executeCreateEnvironmentEC2(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateEnvironmentMembershipResult> createEnvironmentMembershipAsync(CreateEnvironmentMembershipRequest request) {
        return this.createEnvironmentMembershipAsync(request, null);
    }

    @Override
    public Future<CreateEnvironmentMembershipResult> createEnvironmentMembershipAsync(CreateEnvironmentMembershipRequest request, final AsyncHandler<CreateEnvironmentMembershipRequest, CreateEnvironmentMembershipResult> asyncHandler) {
        final CreateEnvironmentMembershipRequest finalRequest = (CreateEnvironmentMembershipRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateEnvironmentMembershipResult>(){

            @Override
            public CreateEnvironmentMembershipResult call() throws Exception {
                CreateEnvironmentMembershipResult result = null;
                try {
                    result = AWSCloud9AsyncClient.this.executeCreateEnvironmentMembership(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteEnvironmentResult> deleteEnvironmentAsync(DeleteEnvironmentRequest request) {
        return this.deleteEnvironmentAsync(request, null);
    }

    @Override
    public Future<DeleteEnvironmentResult> deleteEnvironmentAsync(DeleteEnvironmentRequest request, final AsyncHandler<DeleteEnvironmentRequest, DeleteEnvironmentResult> asyncHandler) {
        final DeleteEnvironmentRequest finalRequest = (DeleteEnvironmentRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteEnvironmentResult>(){

            @Override
            public DeleteEnvironmentResult call() throws Exception {
                DeleteEnvironmentResult result = null;
                try {
                    result = AWSCloud9AsyncClient.this.executeDeleteEnvironment(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteEnvironmentMembershipResult> deleteEnvironmentMembershipAsync(DeleteEnvironmentMembershipRequest request) {
        return this.deleteEnvironmentMembershipAsync(request, null);
    }

    @Override
    public Future<DeleteEnvironmentMembershipResult> deleteEnvironmentMembershipAsync(DeleteEnvironmentMembershipRequest request, final AsyncHandler<DeleteEnvironmentMembershipRequest, DeleteEnvironmentMembershipResult> asyncHandler) {
        final DeleteEnvironmentMembershipRequest finalRequest = (DeleteEnvironmentMembershipRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteEnvironmentMembershipResult>(){

            @Override
            public DeleteEnvironmentMembershipResult call() throws Exception {
                DeleteEnvironmentMembershipResult result = null;
                try {
                    result = AWSCloud9AsyncClient.this.executeDeleteEnvironmentMembership(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEnvironmentMembershipsResult> describeEnvironmentMembershipsAsync(DescribeEnvironmentMembershipsRequest request) {
        return this.describeEnvironmentMembershipsAsync(request, null);
    }

    @Override
    public Future<DescribeEnvironmentMembershipsResult> describeEnvironmentMembershipsAsync(DescribeEnvironmentMembershipsRequest request, final AsyncHandler<DescribeEnvironmentMembershipsRequest, DescribeEnvironmentMembershipsResult> asyncHandler) {
        final DescribeEnvironmentMembershipsRequest finalRequest = (DescribeEnvironmentMembershipsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeEnvironmentMembershipsResult>(){

            @Override
            public DescribeEnvironmentMembershipsResult call() throws Exception {
                DescribeEnvironmentMembershipsResult result = null;
                try {
                    result = AWSCloud9AsyncClient.this.executeDescribeEnvironmentMemberships(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEnvironmentStatusResult> describeEnvironmentStatusAsync(DescribeEnvironmentStatusRequest request) {
        return this.describeEnvironmentStatusAsync(request, null);
    }

    @Override
    public Future<DescribeEnvironmentStatusResult> describeEnvironmentStatusAsync(DescribeEnvironmentStatusRequest request, final AsyncHandler<DescribeEnvironmentStatusRequest, DescribeEnvironmentStatusResult> asyncHandler) {
        final DescribeEnvironmentStatusRequest finalRequest = (DescribeEnvironmentStatusRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeEnvironmentStatusResult>(){

            @Override
            public DescribeEnvironmentStatusResult call() throws Exception {
                DescribeEnvironmentStatusResult result = null;
                try {
                    result = AWSCloud9AsyncClient.this.executeDescribeEnvironmentStatus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEnvironmentsResult> describeEnvironmentsAsync(DescribeEnvironmentsRequest request) {
        return this.describeEnvironmentsAsync(request, null);
    }

    @Override
    public Future<DescribeEnvironmentsResult> describeEnvironmentsAsync(DescribeEnvironmentsRequest request, final AsyncHandler<DescribeEnvironmentsRequest, DescribeEnvironmentsResult> asyncHandler) {
        final DescribeEnvironmentsRequest finalRequest = (DescribeEnvironmentsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeEnvironmentsResult>(){

            @Override
            public DescribeEnvironmentsResult call() throws Exception {
                DescribeEnvironmentsResult result = null;
                try {
                    result = AWSCloud9AsyncClient.this.executeDescribeEnvironments(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListEnvironmentsResult> listEnvironmentsAsync(ListEnvironmentsRequest request) {
        return this.listEnvironmentsAsync(request, null);
    }

    @Override
    public Future<ListEnvironmentsResult> listEnvironmentsAsync(ListEnvironmentsRequest request, final AsyncHandler<ListEnvironmentsRequest, ListEnvironmentsResult> asyncHandler) {
        final ListEnvironmentsRequest finalRequest = (ListEnvironmentsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListEnvironmentsResult>(){

            @Override
            public ListEnvironmentsResult call() throws Exception {
                ListEnvironmentsResult result = null;
                try {
                    result = AWSCloud9AsyncClient.this.executeListEnvironments(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSCloud9AsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSCloud9AsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSCloud9AsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateEnvironmentResult> updateEnvironmentAsync(UpdateEnvironmentRequest request) {
        return this.updateEnvironmentAsync(request, null);
    }

    @Override
    public Future<UpdateEnvironmentResult> updateEnvironmentAsync(UpdateEnvironmentRequest request, final AsyncHandler<UpdateEnvironmentRequest, UpdateEnvironmentResult> asyncHandler) {
        final UpdateEnvironmentRequest finalRequest = (UpdateEnvironmentRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateEnvironmentResult>(){

            @Override
            public UpdateEnvironmentResult call() throws Exception {
                UpdateEnvironmentResult result = null;
                try {
                    result = AWSCloud9AsyncClient.this.executeUpdateEnvironment(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateEnvironmentMembershipResult> updateEnvironmentMembershipAsync(UpdateEnvironmentMembershipRequest request) {
        return this.updateEnvironmentMembershipAsync(request, null);
    }

    @Override
    public Future<UpdateEnvironmentMembershipResult> updateEnvironmentMembershipAsync(UpdateEnvironmentMembershipRequest request, final AsyncHandler<UpdateEnvironmentMembershipRequest, UpdateEnvironmentMembershipResult> asyncHandler) {
        final UpdateEnvironmentMembershipRequest finalRequest = (UpdateEnvironmentMembershipRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateEnvironmentMembershipResult>(){

            @Override
            public UpdateEnvironmentMembershipResult call() throws Exception {
                UpdateEnvironmentMembershipResult result = null;
                try {
                    result = AWSCloud9AsyncClient.this.executeUpdateEnvironmentMembership(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

