/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudformation.model.Parameter;
import com.amazonaws.services.cloudformation.model.StackInstanceStatus;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class StackInstance
implements Serializable,
Cloneable {
    private String stackSetId;
    private String region;
    private String account;
    private String stackId;
    private SdkInternalList<Parameter> parameterOverrides;
    private String status;
    private String statusReason;

    public void setStackSetId(String stackSetId) {
        this.stackSetId = stackSetId;
    }

    public String getStackSetId() {
        return this.stackSetId;
    }

    public StackInstance withStackSetId(String stackSetId) {
        this.setStackSetId(stackSetId);
        return this;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getRegion() {
        return this.region;
    }

    public StackInstance withRegion(String region) {
        this.setRegion(region);
        return this;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getAccount() {
        return this.account;
    }

    public StackInstance withAccount(String account) {
        this.setAccount(account);
        return this;
    }

    public void setStackId(String stackId) {
        this.stackId = stackId;
    }

    public String getStackId() {
        return this.stackId;
    }

    public StackInstance withStackId(String stackId) {
        this.setStackId(stackId);
        return this;
    }

    public List<Parameter> getParameterOverrides() {
        if (this.parameterOverrides == null) {
            this.parameterOverrides = new SdkInternalList();
        }
        return this.parameterOverrides;
    }

    public void setParameterOverrides(Collection<Parameter> parameterOverrides) {
        if (parameterOverrides == null) {
            this.parameterOverrides = null;
            return;
        }
        this.parameterOverrides = new SdkInternalList(parameterOverrides);
    }

    public StackInstance withParameterOverrides(Parameter ... parameterOverrides) {
        if (this.parameterOverrides == null) {
            this.setParameterOverrides((Collection<Parameter>)new SdkInternalList(parameterOverrides.length));
        }
        for (Parameter ele : parameterOverrides) {
            this.parameterOverrides.add((Object)ele);
        }
        return this;
    }

    public StackInstance withParameterOverrides(Collection<Parameter> parameterOverrides) {
        this.setParameterOverrides(parameterOverrides);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public StackInstance withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public void setStatus(StackInstanceStatus status) {
        this.withStatus(status);
    }

    public StackInstance withStatus(StackInstanceStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setStatusReason(String statusReason) {
        this.statusReason = statusReason;
    }

    public String getStatusReason() {
        return this.statusReason;
    }

    public StackInstance withStatusReason(String statusReason) {
        this.setStatusReason(statusReason);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStackSetId() != null) {
            sb.append("StackSetId: ").append(this.getStackSetId()).append(",");
        }
        if (this.getRegion() != null) {
            sb.append("Region: ").append(this.getRegion()).append(",");
        }
        if (this.getAccount() != null) {
            sb.append("Account: ").append(this.getAccount()).append(",");
        }
        if (this.getStackId() != null) {
            sb.append("StackId: ").append(this.getStackId()).append(",");
        }
        if (this.getParameterOverrides() != null) {
            sb.append("ParameterOverrides: ").append(this.getParameterOverrides()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getStatusReason() != null) {
            sb.append("StatusReason: ").append(this.getStatusReason());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackInstance)) {
            return false;
        }
        StackInstance other = (StackInstance)obj;
        if (other.getStackSetId() == null ^ this.getStackSetId() == null) {
            return false;
        }
        if (other.getStackSetId() != null && !other.getStackSetId().equals(this.getStackSetId())) {
            return false;
        }
        if (other.getRegion() == null ^ this.getRegion() == null) {
            return false;
        }
        if (other.getRegion() != null && !other.getRegion().equals(this.getRegion())) {
            return false;
        }
        if (other.getAccount() == null ^ this.getAccount() == null) {
            return false;
        }
        if (other.getAccount() != null && !other.getAccount().equals(this.getAccount())) {
            return false;
        }
        if (other.getStackId() == null ^ this.getStackId() == null) {
            return false;
        }
        if (other.getStackId() != null && !other.getStackId().equals(this.getStackId())) {
            return false;
        }
        if (other.getParameterOverrides() == null ^ this.getParameterOverrides() == null) {
            return false;
        }
        if (other.getParameterOverrides() != null && !other.getParameterOverrides().equals(this.getParameterOverrides())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getStatusReason() == null ^ this.getStatusReason() == null) {
            return false;
        }
        return other.getStatusReason() == null || other.getStatusReason().equals(this.getStatusReason());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStackSetId() == null ? 0 : this.getStackSetId().hashCode());
        hashCode = 31 * hashCode + (this.getRegion() == null ? 0 : this.getRegion().hashCode());
        hashCode = 31 * hashCode + (this.getAccount() == null ? 0 : this.getAccount().hashCode());
        hashCode = 31 * hashCode + (this.getStackId() == null ? 0 : this.getStackId().hashCode());
        hashCode = 31 * hashCode + (this.getParameterOverrides() == null ? 0 : this.getParameterOverrides().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getStatusReason() == null ? 0 : this.getStatusReason().hashCode());
        return hashCode;
    }

    public StackInstance clone() {
        try {
            return (StackInstance)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

