/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudfront.model.Method;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CachedMethods
implements Serializable,
Cloneable {
    private Integer quantity;
    private SdkInternalList<String> items;

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public CachedMethods withQuantity(Integer quantity) {
        this.setQuantity(quantity);
        return this;
    }

    public List<String> getItems() {
        if (this.items == null) {
            this.items = new SdkInternalList();
        }
        return this.items;
    }

    public void setItems(Collection<String> items) {
        if (items == null) {
            this.items = null;
            return;
        }
        this.items = new SdkInternalList(items);
    }

    public CachedMethods withItems(String ... items) {
        if (this.items == null) {
            this.setItems((Collection<String>)new SdkInternalList(items.length));
        }
        for (String ele : items) {
            this.items.add((Object)ele);
        }
        return this;
    }

    public CachedMethods withItems(Collection<String> items) {
        this.setItems(items);
        return this;
    }

    public CachedMethods withItems(Method ... items) {
        SdkInternalList itemsCopy = new SdkInternalList(items.length);
        for (Method value : items) {
            itemsCopy.add((Object)value.toString());
        }
        if (this.getItems() == null) {
            this.setItems((Collection<String>)itemsCopy);
        } else {
            this.getItems().addAll((Collection<String>)itemsCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getQuantity() != null) {
            sb.append("Quantity: " + this.getQuantity() + ",");
        }
        if (this.getItems() != null) {
            sb.append("Items: " + this.getItems());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CachedMethods)) {
            return false;
        }
        CachedMethods other = (CachedMethods)obj;
        if (other.getQuantity() == null ^ this.getQuantity() == null) {
            return false;
        }
        if (other.getQuantity() != null && !other.getQuantity().equals(this.getQuantity())) {
            return false;
        }
        if (other.getItems() == null ^ this.getItems() == null) {
            return false;
        }
        return other.getItems() == null || other.getItems().equals(this.getItems());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getQuantity() == null ? 0 : this.getQuantity().hashCode());
        hashCode = 31 * hashCode + (this.getItems() == null ? 0 : this.getItems().hashCode());
        return hashCode;
    }

    public CachedMethods clone() {
        try {
            return (CachedMethods)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

