/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.GetFunctionResult;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.IOUtils;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class GetFunctionResultStaxUnmarshaller
implements Unmarshaller<GetFunctionResult, StaxUnmarshallerContext> {
    private static GetFunctionResultStaxUnmarshaller instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetFunctionResult unmarshall(StaxUnmarshallerContext context) throws Exception {
        InputStream is;
        GetFunctionResult getFunctionResult = new GetFunctionResult();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            context.setCurrentHeader("ETag");
            getFunctionResult.setETag(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("Content-Type");
            getFunctionResult.setContentType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
        }
        if ((is = context.getHttpResponse().getContent()) != null) {
            try {
                getFunctionResult.setFunctionCode(ByteBuffer.wrap(IOUtils.toByteArray((InputStream)is)));
            }
            finally {
                IOUtils.closeQuietly((Closeable)is, null);
            }
        }
        return getFunctionResult;
    }

    public static GetFunctionResultStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new GetFunctionResultStaxUnmarshaller();
        }
        return instance;
    }
}

