/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.KinesisStreamConfig;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class KinesisStreamConfigStaxUnmarshaller
implements Unmarshaller<KinesisStreamConfig, StaxUnmarshallerContext> {
    private static KinesisStreamConfigStaxUnmarshaller instance;

    public KinesisStreamConfig unmarshall(StaxUnmarshallerContext context) throws Exception {
        KinesisStreamConfig kinesisStreamConfig = new KinesisStreamConfig();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return kinesisStreamConfig;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("RoleARN", targetDepth)) {
                    kinesisStreamConfig.setRoleARN(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("StreamARN", targetDepth)) continue;
                kinesisStreamConfig.setStreamARN(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return kinesisStreamConfig;
    }

    public static KinesisStreamConfigStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new KinesisStreamConfigStaxUnmarshaller();
        }
        return instance;
    }
}

