/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudfront.model.EndPoint;
import com.amazonaws.services.cloudfront.model.KinesisStreamConfig;
import com.amazonaws.services.cloudfront.model.UpdateRealtimeLogConfigRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class UpdateRealtimeLogConfigRequestMarshaller
implements Marshaller<Request<UpdateRealtimeLogConfigRequest>, UpdateRealtimeLogConfigRequest> {
    public Request<UpdateRealtimeLogConfigRequest> marshall(UpdateRealtimeLogConfigRequest updateRealtimeLogConfigRequest) {
        if (updateRealtimeLogConfigRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateRealtimeLogConfigRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/2020-05-31/realtime-log-config/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, "http://cloudfront.amazonaws.com/doc/2020-05-31/");
            xmlWriter.startElement("UpdateRealtimeLogConfigRequest");
            if (updateRealtimeLogConfigRequest != null) {
                SdkInternalList updateRealtimeLogConfigRequestFieldsList;
                SdkInternalList updateRealtimeLogConfigRequestEndPointsList = (SdkInternalList)updateRealtimeLogConfigRequest.getEndPoints();
                if (!updateRealtimeLogConfigRequestEndPointsList.isEmpty() || !updateRealtimeLogConfigRequestEndPointsList.isAutoConstruct()) {
                    xmlWriter.startElement("EndPoints");
                    for (EndPoint updateRealtimeLogConfigRequestEndPointsListValue : updateRealtimeLogConfigRequestEndPointsList) {
                        KinesisStreamConfig kinesisStreamConfig;
                        xmlWriter.startElement("member");
                        if (updateRealtimeLogConfigRequestEndPointsListValue.getStreamType() != null) {
                            xmlWriter.startElement("StreamType").value(updateRealtimeLogConfigRequestEndPointsListValue.getStreamType()).endElement();
                        }
                        if ((kinesisStreamConfig = updateRealtimeLogConfigRequestEndPointsListValue.getKinesisStreamConfig()) != null) {
                            xmlWriter.startElement("KinesisStreamConfig");
                            if (kinesisStreamConfig.getRoleARN() != null) {
                                xmlWriter.startElement("RoleARN").value(kinesisStreamConfig.getRoleARN()).endElement();
                            }
                            if (kinesisStreamConfig.getStreamARN() != null) {
                                xmlWriter.startElement("StreamARN").value(kinesisStreamConfig.getStreamARN()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if (!(updateRealtimeLogConfigRequestFieldsList = (SdkInternalList)updateRealtimeLogConfigRequest.getFields()).isEmpty() || !updateRealtimeLogConfigRequestFieldsList.isAutoConstruct()) {
                    xmlWriter.startElement("Fields");
                    for (String updateRealtimeLogConfigRequestFieldsListValue : updateRealtimeLogConfigRequestFieldsList) {
                        xmlWriter.startElement("Field");
                        xmlWriter.value(updateRealtimeLogConfigRequestFieldsListValue);
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if (updateRealtimeLogConfigRequest.getName() != null) {
                    xmlWriter.startElement("Name").value(updateRealtimeLogConfigRequest.getName()).endElement();
                }
                if (updateRealtimeLogConfigRequest.getARN() != null) {
                    xmlWriter.startElement("ARN").value(updateRealtimeLogConfigRequest.getARN()).endElement();
                }
                if (updateRealtimeLogConfigRequest.getSamplingRate() != null) {
                    xmlWriter.startElement("SamplingRate").value((Object)updateRealtimeLogConfigRequest.getSamplingRate()).endElement();
                }
            }
            xmlWriter.endElement();
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

