/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudhsm.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cloudhsm.model.ModifyLunaClientRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ModifyLunaClientRequestMarshaller
implements Marshaller<Request<ModifyLunaClientRequest>, ModifyLunaClientRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ModifyLunaClientRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ModifyLunaClientRequest> marshall(ModifyLunaClientRequest modifyLunaClientRequest) {
        if (modifyLunaClientRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyLunaClientRequest, "AWSCloudHSM");
        request.addHeader("X-Amz-Target", "CloudHsmFrontendService.ModifyLunaClient");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (modifyLunaClientRequest.getClientArn() != null) {
                jsonGenerator.writeFieldName("ClientArn").writeValue(modifyLunaClientRequest.getClientArn());
            }
            if (modifyLunaClientRequest.getCertificate() != null) {
                jsonGenerator.writeFieldName("Certificate").writeValue(modifyLunaClientRequest.getCertificate());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

