/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatchevidently.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.cloudwatchevidently.model.transform.ScheduledSplitMarshaller;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ScheduledSplit
implements Serializable,
Cloneable,
StructuredPojo {
    private Map<String, Long> groupWeights;
    private Date startTime;

    public Map<String, Long> getGroupWeights() {
        return this.groupWeights;
    }

    public void setGroupWeights(Map<String, Long> groupWeights) {
        this.groupWeights = groupWeights;
    }

    public ScheduledSplit withGroupWeights(Map<String, Long> groupWeights) {
        this.setGroupWeights(groupWeights);
        return this;
    }

    public ScheduledSplit addGroupWeightsEntry(String key, Long value) {
        if (null == this.groupWeights) {
            this.groupWeights = new HashMap<String, Long>();
        }
        if (this.groupWeights.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.groupWeights.put(key, value);
        return this;
    }

    public ScheduledSplit clearGroupWeightsEntries() {
        this.groupWeights = null;
        return this;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public ScheduledSplit withStartTime(Date startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGroupWeights() != null) {
            sb.append("GroupWeights: ").append(this.getGroupWeights()).append(",");
        }
        if (this.getStartTime() != null) {
            sb.append("StartTime: ").append(this.getStartTime());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledSplit)) {
            return false;
        }
        ScheduledSplit other = (ScheduledSplit)obj;
        if (other.getGroupWeights() == null ^ this.getGroupWeights() == null) {
            return false;
        }
        if (other.getGroupWeights() != null && !other.getGroupWeights().equals(this.getGroupWeights())) {
            return false;
        }
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        return other.getStartTime() == null || other.getStartTime().equals(this.getStartTime());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGroupWeights() == null ? 0 : this.getGroupWeights().hashCode());
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        return hashCode;
    }

    public ScheduledSplit clone() {
        try {
            return (ScheduledSplit)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ScheduledSplitMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

