/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatchrum.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.cloudwatchrum.model.RumEvent;
import java.util.Date;

@SdkInternalApi
public class RumEventMarshaller {
    private static final MarshallingInfo<String> DETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.JSON_VALUE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("details").build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").build();
    private static final MarshallingInfo<String> METADATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.JSON_VALUE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("metadata").build();
    private static final MarshallingInfo<Date> TIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timestamp").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").build();
    private static final RumEventMarshaller instance = new RumEventMarshaller();

    public static RumEventMarshaller getInstance() {
        return instance;
    }

    public void marshall(RumEvent rumEvent, ProtocolMarshaller protocolMarshaller) {
        if (rumEvent == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)rumEvent.getDetails(), DETAILS_BINDING);
            protocolMarshaller.marshall((Object)rumEvent.getId(), ID_BINDING);
            protocolMarshaller.marshall((Object)rumEvent.getMetadata(), METADATA_BINDING);
            protocolMarshaller.marshall((Object)rumEvent.getTimestamp(), TIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)rumEvent.getType(), TYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

