/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.codecommit.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.codecommit.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * GetFolderResult JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetFolderResultJsonUnmarshaller implements Unmarshaller<GetFolderResult, JsonUnmarshallerContext> {

    public GetFolderResult unmarshall(JsonUnmarshallerContext context) throws Exception {
        GetFolderResult getFolderResult = new GetFolderResult();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return getFolderResult;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("commitId", targetDepth)) {
                    context.nextToken();
                    getFolderResult.setCommitId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("folderPath", targetDepth)) {
                    context.nextToken();
                    getFolderResult.setFolderPath(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("treeId", targetDepth)) {
                    context.nextToken();
                    getFolderResult.setTreeId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("subFolders", targetDepth)) {
                    context.nextToken();
                    getFolderResult.setSubFolders(new ListUnmarshaller<Folder>(FolderJsonUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("files", targetDepth)) {
                    context.nextToken();
                    getFolderResult.setFiles(new ListUnmarshaller<File>(FileJsonUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("symbolicLinks", targetDepth)) {
                    context.nextToken();
                    getFolderResult.setSymbolicLinks(new ListUnmarshaller<SymbolicLink>(SymbolicLinkJsonUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("subModules", targetDepth)) {
                    context.nextToken();
                    getFolderResult.setSubModules(new ListUnmarshaller<SubModule>(SubModuleJsonUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return getFolderResult;
    }

    private static GetFolderResultJsonUnmarshaller instance;

    public static GetFolderResultJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new GetFolderResultJsonUnmarshaller();
        return instance;
    }
}
