/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.codecommit.model.SubModule;

@SdkInternalApi
public class SubModuleMarshaller {
    private static final MarshallingInfo<String> COMMITID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("commitId").build();
    private static final MarshallingInfo<String> ABSOLUTEPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("absolutePath").build();
    private static final MarshallingInfo<String> RELATIVEPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("relativePath").build();
    private static final SubModuleMarshaller instance = new SubModuleMarshaller();

    public static SubModuleMarshaller getInstance() {
        return instance;
    }

    public void marshall(SubModule subModule, ProtocolMarshaller protocolMarshaller) {
        if (subModule == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)subModule.getCommitId(), COMMITID_BINDING);
            protocolMarshaller.marshall((Object)subModule.getAbsolutePath(), ABSOLUTEPATH_BINDING);
            protocolMarshaller.marshall((Object)subModule.getRelativePath(), RELATIVEPATH_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

