/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codecommit.model.RepositoryTrigger;
import com.amazonaws.services.codecommit.model.TestRepositoryTriggersRequest;
import com.amazonaws.services.codecommit.model.transform.RepositoryTriggerJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class TestRepositoryTriggersRequestMarshaller
implements Marshaller<Request<TestRepositoryTriggersRequest>, TestRepositoryTriggersRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public TestRepositoryTriggersRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<TestRepositoryTriggersRequest> marshall(TestRepositoryTriggersRequest testRepositoryTriggersRequest) {
        if (testRepositoryTriggersRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)testRepositoryTriggersRequest, "AWSCodeCommit");
        request.addHeader("X-Amz-Target", "CodeCommit_20150413.TestRepositoryTriggers");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<RepositoryTrigger> triggersList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (testRepositoryTriggersRequest.getRepositoryName() != null) {
                jsonGenerator.writeFieldName("repositoryName").writeValue(testRepositoryTriggersRequest.getRepositoryName());
            }
            if ((triggersList = testRepositoryTriggersRequest.getTriggers()) != null) {
                jsonGenerator.writeFieldName("triggers");
                jsonGenerator.writeStartArray();
                for (RepositoryTrigger triggersListValue : triggersList) {
                    if (triggersListValue == null) continue;
                    RepositoryTriggerJsonMarshaller.getInstance().marshall(triggersListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

