/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codecommit.model.CreateBranchRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CreateBranchRequestMarshaller
implements Marshaller<Request<CreateBranchRequest>, CreateBranchRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public CreateBranchRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateBranchRequest> marshall(CreateBranchRequest createBranchRequest) {
        if (createBranchRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createBranchRequest, "AWSCodeCommit");
        request.addHeader("X-Amz-Target", "CodeCommit_20150413.CreateBranch");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createBranchRequest.getRepositoryName() != null) {
                jsonGenerator.writeFieldName("repositoryName").writeValue(createBranchRequest.getRepositoryName());
            }
            if (createBranchRequest.getBranchName() != null) {
                jsonGenerator.writeFieldName("branchName").writeValue(createBranchRequest.getBranchName());
            }
            if (createBranchRequest.getCommitId() != null) {
                jsonGenerator.writeFieldName("commitId").writeValue(createBranchRequest.getCommitId());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

