/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.codecommit.model.BatchGetCommitsError;
import com.amazonaws.services.codecommit.model.Commit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchGetCommitsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Commit> commits;
    private List<BatchGetCommitsError> errors;

    public List<Commit> getCommits() {
        return this.commits;
    }

    public void setCommits(Collection<Commit> commits) {
        if (commits == null) {
            this.commits = null;
            return;
        }
        this.commits = new ArrayList<Commit>(commits);
    }

    public BatchGetCommitsResult withCommits(Commit ... commits) {
        if (this.commits == null) {
            this.setCommits(new ArrayList<Commit>(commits.length));
        }
        for (Commit ele : commits) {
            this.commits.add(ele);
        }
        return this;
    }

    public BatchGetCommitsResult withCommits(Collection<Commit> commits) {
        this.setCommits(commits);
        return this;
    }

    public List<BatchGetCommitsError> getErrors() {
        return this.errors;
    }

    public void setErrors(Collection<BatchGetCommitsError> errors) {
        if (errors == null) {
            this.errors = null;
            return;
        }
        this.errors = new ArrayList<BatchGetCommitsError>(errors);
    }

    public BatchGetCommitsResult withErrors(BatchGetCommitsError ... errors) {
        if (this.errors == null) {
            this.setErrors(new ArrayList<BatchGetCommitsError>(errors.length));
        }
        for (BatchGetCommitsError ele : errors) {
            this.errors.add(ele);
        }
        return this;
    }

    public BatchGetCommitsResult withErrors(Collection<BatchGetCommitsError> errors) {
        this.setErrors(errors);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCommits() != null) {
            sb.append("Commits: ").append(this.getCommits()).append(",");
        }
        if (this.getErrors() != null) {
            sb.append("Errors: ").append(this.getErrors());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetCommitsResult)) {
            return false;
        }
        BatchGetCommitsResult other = (BatchGetCommitsResult)obj;
        if (other.getCommits() == null ^ this.getCommits() == null) {
            return false;
        }
        if (other.getCommits() != null && !other.getCommits().equals(this.getCommits())) {
            return false;
        }
        if (other.getErrors() == null ^ this.getErrors() == null) {
            return false;
        }
        return other.getErrors() == null || other.getErrors().equals(this.getErrors());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCommits() == null ? 0 : this.getCommits().hashCode());
        hashCode = 31 * hashCode + (this.getErrors() == null ? 0 : this.getErrors().hashCode());
        return hashCode;
    }

    public BatchGetCommitsResult clone() {
        try {
            return (BatchGetCommitsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

