/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.codecommit.model.DeleteFileEntry;
import com.amazonaws.services.codecommit.model.PutFileEntry;
import com.amazonaws.services.codecommit.model.SetFileModeEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateCommitRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String repositoryName;
    private String branchName;
    private String parentCommitId;
    private String authorName;
    private String email;
    private String commitMessage;
    private Boolean keepEmptyFolders;
    private List<PutFileEntry> putFiles;
    private List<DeleteFileEntry> deleteFiles;
    private List<SetFileModeEntry> setFileModes;

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public CreateCommitRequest withRepositoryName(String repositoryName) {
        this.setRepositoryName(repositoryName);
        return this;
    }

    public void setBranchName(String branchName) {
        this.branchName = branchName;
    }

    public String getBranchName() {
        return this.branchName;
    }

    public CreateCommitRequest withBranchName(String branchName) {
        this.setBranchName(branchName);
        return this;
    }

    public void setParentCommitId(String parentCommitId) {
        this.parentCommitId = parentCommitId;
    }

    public String getParentCommitId() {
        return this.parentCommitId;
    }

    public CreateCommitRequest withParentCommitId(String parentCommitId) {
        this.setParentCommitId(parentCommitId);
        return this;
    }

    public void setAuthorName(String authorName) {
        this.authorName = authorName;
    }

    public String getAuthorName() {
        return this.authorName;
    }

    public CreateCommitRequest withAuthorName(String authorName) {
        this.setAuthorName(authorName);
        return this;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getEmail() {
        return this.email;
    }

    public CreateCommitRequest withEmail(String email) {
        this.setEmail(email);
        return this;
    }

    public void setCommitMessage(String commitMessage) {
        this.commitMessage = commitMessage;
    }

    public String getCommitMessage() {
        return this.commitMessage;
    }

    public CreateCommitRequest withCommitMessage(String commitMessage) {
        this.setCommitMessage(commitMessage);
        return this;
    }

    public void setKeepEmptyFolders(Boolean keepEmptyFolders) {
        this.keepEmptyFolders = keepEmptyFolders;
    }

    public Boolean getKeepEmptyFolders() {
        return this.keepEmptyFolders;
    }

    public CreateCommitRequest withKeepEmptyFolders(Boolean keepEmptyFolders) {
        this.setKeepEmptyFolders(keepEmptyFolders);
        return this;
    }

    public Boolean isKeepEmptyFolders() {
        return this.keepEmptyFolders;
    }

    public List<PutFileEntry> getPutFiles() {
        return this.putFiles;
    }

    public void setPutFiles(Collection<PutFileEntry> putFiles) {
        if (putFiles == null) {
            this.putFiles = null;
            return;
        }
        this.putFiles = new ArrayList<PutFileEntry>(putFiles);
    }

    public CreateCommitRequest withPutFiles(PutFileEntry ... putFiles) {
        if (this.putFiles == null) {
            this.setPutFiles(new ArrayList<PutFileEntry>(putFiles.length));
        }
        for (PutFileEntry ele : putFiles) {
            this.putFiles.add(ele);
        }
        return this;
    }

    public CreateCommitRequest withPutFiles(Collection<PutFileEntry> putFiles) {
        this.setPutFiles(putFiles);
        return this;
    }

    public List<DeleteFileEntry> getDeleteFiles() {
        return this.deleteFiles;
    }

    public void setDeleteFiles(Collection<DeleteFileEntry> deleteFiles) {
        if (deleteFiles == null) {
            this.deleteFiles = null;
            return;
        }
        this.deleteFiles = new ArrayList<DeleteFileEntry>(deleteFiles);
    }

    public CreateCommitRequest withDeleteFiles(DeleteFileEntry ... deleteFiles) {
        if (this.deleteFiles == null) {
            this.setDeleteFiles(new ArrayList<DeleteFileEntry>(deleteFiles.length));
        }
        for (DeleteFileEntry ele : deleteFiles) {
            this.deleteFiles.add(ele);
        }
        return this;
    }

    public CreateCommitRequest withDeleteFiles(Collection<DeleteFileEntry> deleteFiles) {
        this.setDeleteFiles(deleteFiles);
        return this;
    }

    public List<SetFileModeEntry> getSetFileModes() {
        return this.setFileModes;
    }

    public void setSetFileModes(Collection<SetFileModeEntry> setFileModes) {
        if (setFileModes == null) {
            this.setFileModes = null;
            return;
        }
        this.setFileModes = new ArrayList<SetFileModeEntry>(setFileModes);
    }

    public CreateCommitRequest withSetFileModes(SetFileModeEntry ... setFileModes) {
        if (this.setFileModes == null) {
            this.setSetFileModes(new ArrayList<SetFileModeEntry>(setFileModes.length));
        }
        for (SetFileModeEntry ele : setFileModes) {
            this.setFileModes.add(ele);
        }
        return this;
    }

    public CreateCommitRequest withSetFileModes(Collection<SetFileModeEntry> setFileModes) {
        this.setSetFileModes(setFileModes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRepositoryName() != null) {
            sb.append("RepositoryName: ").append(this.getRepositoryName()).append(",");
        }
        if (this.getBranchName() != null) {
            sb.append("BranchName: ").append(this.getBranchName()).append(",");
        }
        if (this.getParentCommitId() != null) {
            sb.append("ParentCommitId: ").append(this.getParentCommitId()).append(",");
        }
        if (this.getAuthorName() != null) {
            sb.append("AuthorName: ").append(this.getAuthorName()).append(",");
        }
        if (this.getEmail() != null) {
            sb.append("Email: ").append(this.getEmail()).append(",");
        }
        if (this.getCommitMessage() != null) {
            sb.append("CommitMessage: ").append(this.getCommitMessage()).append(",");
        }
        if (this.getKeepEmptyFolders() != null) {
            sb.append("KeepEmptyFolders: ").append(this.getKeepEmptyFolders()).append(",");
        }
        if (this.getPutFiles() != null) {
            sb.append("PutFiles: ").append(this.getPutFiles()).append(",");
        }
        if (this.getDeleteFiles() != null) {
            sb.append("DeleteFiles: ").append(this.getDeleteFiles()).append(",");
        }
        if (this.getSetFileModes() != null) {
            sb.append("SetFileModes: ").append(this.getSetFileModes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCommitRequest)) {
            return false;
        }
        CreateCommitRequest other = (CreateCommitRequest)obj;
        if (other.getRepositoryName() == null ^ this.getRepositoryName() == null) {
            return false;
        }
        if (other.getRepositoryName() != null && !other.getRepositoryName().equals(this.getRepositoryName())) {
            return false;
        }
        if (other.getBranchName() == null ^ this.getBranchName() == null) {
            return false;
        }
        if (other.getBranchName() != null && !other.getBranchName().equals(this.getBranchName())) {
            return false;
        }
        if (other.getParentCommitId() == null ^ this.getParentCommitId() == null) {
            return false;
        }
        if (other.getParentCommitId() != null && !other.getParentCommitId().equals(this.getParentCommitId())) {
            return false;
        }
        if (other.getAuthorName() == null ^ this.getAuthorName() == null) {
            return false;
        }
        if (other.getAuthorName() != null && !other.getAuthorName().equals(this.getAuthorName())) {
            return false;
        }
        if (other.getEmail() == null ^ this.getEmail() == null) {
            return false;
        }
        if (other.getEmail() != null && !other.getEmail().equals(this.getEmail())) {
            return false;
        }
        if (other.getCommitMessage() == null ^ this.getCommitMessage() == null) {
            return false;
        }
        if (other.getCommitMessage() != null && !other.getCommitMessage().equals(this.getCommitMessage())) {
            return false;
        }
        if (other.getKeepEmptyFolders() == null ^ this.getKeepEmptyFolders() == null) {
            return false;
        }
        if (other.getKeepEmptyFolders() != null && !other.getKeepEmptyFolders().equals(this.getKeepEmptyFolders())) {
            return false;
        }
        if (other.getPutFiles() == null ^ this.getPutFiles() == null) {
            return false;
        }
        if (other.getPutFiles() != null && !other.getPutFiles().equals(this.getPutFiles())) {
            return false;
        }
        if (other.getDeleteFiles() == null ^ this.getDeleteFiles() == null) {
            return false;
        }
        if (other.getDeleteFiles() != null && !other.getDeleteFiles().equals(this.getDeleteFiles())) {
            return false;
        }
        if (other.getSetFileModes() == null ^ this.getSetFileModes() == null) {
            return false;
        }
        return other.getSetFileModes() == null || other.getSetFileModes().equals(this.getSetFileModes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRepositoryName() == null ? 0 : this.getRepositoryName().hashCode());
        hashCode = 31 * hashCode + (this.getBranchName() == null ? 0 : this.getBranchName().hashCode());
        hashCode = 31 * hashCode + (this.getParentCommitId() == null ? 0 : this.getParentCommitId().hashCode());
        hashCode = 31 * hashCode + (this.getAuthorName() == null ? 0 : this.getAuthorName().hashCode());
        hashCode = 31 * hashCode + (this.getEmail() == null ? 0 : this.getEmail().hashCode());
        hashCode = 31 * hashCode + (this.getCommitMessage() == null ? 0 : this.getCommitMessage().hashCode());
        hashCode = 31 * hashCode + (this.getKeepEmptyFolders() == null ? 0 : this.getKeepEmptyFolders().hashCode());
        hashCode = 31 * hashCode + (this.getPutFiles() == null ? 0 : this.getPutFiles().hashCode());
        hashCode = 31 * hashCode + (this.getDeleteFiles() == null ? 0 : this.getDeleteFiles().hashCode());
        hashCode = 31 * hashCode + (this.getSetFileModes() == null ? 0 : this.getSetFileModes().hashCode());
        return hashCode;
    }

    public CreateCommitRequest clone() {
        return (CreateCommitRequest)super.clone();
    }
}

