/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codecommit.model.FileModeTypeEnum;
import com.amazonaws.services.codecommit.model.transform.FileMarshaller;
import java.io.Serializable;

public class File
implements Serializable,
Cloneable,
StructuredPojo {
    private String blobId;
    private String absolutePath;
    private String relativePath;
    private String fileMode;

    public void setBlobId(String blobId) {
        this.blobId = blobId;
    }

    public String getBlobId() {
        return this.blobId;
    }

    public File withBlobId(String blobId) {
        this.setBlobId(blobId);
        return this;
    }

    public void setAbsolutePath(String absolutePath) {
        this.absolutePath = absolutePath;
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public File withAbsolutePath(String absolutePath) {
        this.setAbsolutePath(absolutePath);
        return this;
    }

    public void setRelativePath(String relativePath) {
        this.relativePath = relativePath;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public File withRelativePath(String relativePath) {
        this.setRelativePath(relativePath);
        return this;
    }

    public void setFileMode(String fileMode) {
        this.fileMode = fileMode;
    }

    public String getFileMode() {
        return this.fileMode;
    }

    public File withFileMode(String fileMode) {
        this.setFileMode(fileMode);
        return this;
    }

    public File withFileMode(FileModeTypeEnum fileMode) {
        this.fileMode = fileMode.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBlobId() != null) {
            sb.append("BlobId: ").append(this.getBlobId()).append(",");
        }
        if (this.getAbsolutePath() != null) {
            sb.append("AbsolutePath: ").append(this.getAbsolutePath()).append(",");
        }
        if (this.getRelativePath() != null) {
            sb.append("RelativePath: ").append(this.getRelativePath()).append(",");
        }
        if (this.getFileMode() != null) {
            sb.append("FileMode: ").append(this.getFileMode());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof File)) {
            return false;
        }
        File other = (File)obj;
        if (other.getBlobId() == null ^ this.getBlobId() == null) {
            return false;
        }
        if (other.getBlobId() != null && !other.getBlobId().equals(this.getBlobId())) {
            return false;
        }
        if (other.getAbsolutePath() == null ^ this.getAbsolutePath() == null) {
            return false;
        }
        if (other.getAbsolutePath() != null && !other.getAbsolutePath().equals(this.getAbsolutePath())) {
            return false;
        }
        if (other.getRelativePath() == null ^ this.getRelativePath() == null) {
            return false;
        }
        if (other.getRelativePath() != null && !other.getRelativePath().equals(this.getRelativePath())) {
            return false;
        }
        if (other.getFileMode() == null ^ this.getFileMode() == null) {
            return false;
        }
        return other.getFileMode() == null || other.getFileMode().equals(this.getFileMode());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBlobId() == null ? 0 : this.getBlobId().hashCode());
        hashCode = 31 * hashCode + (this.getAbsolutePath() == null ? 0 : this.getAbsolutePath().hashCode());
        hashCode = 31 * hashCode + (this.getRelativePath() == null ? 0 : this.getRelativePath().hashCode());
        hashCode = 31 * hashCode + (this.getFileMode() == null ? 0 : this.getFileMode().hashCode());
        return hashCode;
    }

    public File clone() {
        try {
            return (File)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FileMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

