/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codecommit.model.ConflictMetadata;

@SdkInternalApi
public class ConflictMetadataMarshaller {
    private static final MarshallingInfo<String> FILEPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("filePath").build();
    private static final MarshallingInfo<StructuredPojo> FILESIZES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fileSizes").build();
    private static final MarshallingInfo<StructuredPojo> FILEMODES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fileModes").build();
    private static final MarshallingInfo<StructuredPojo> OBJECTTYPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("objectTypes").build();
    private static final MarshallingInfo<Integer> NUMBEROFCONFLICTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("numberOfConflicts").build();
    private static final MarshallingInfo<StructuredPojo> ISBINARYFILE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("isBinaryFile").build();
    private static final MarshallingInfo<Boolean> CONTENTCONFLICT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("contentConflict").build();
    private static final MarshallingInfo<Boolean> FILEMODECONFLICT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fileModeConflict").build();
    private static final MarshallingInfo<Boolean> OBJECTTYPECONFLICT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("objectTypeConflict").build();
    private static final MarshallingInfo<StructuredPojo> MERGEOPERATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mergeOperations").build();
    private static final ConflictMetadataMarshaller instance = new ConflictMetadataMarshaller();

    public static ConflictMetadataMarshaller getInstance() {
        return instance;
    }

    public void marshall(ConflictMetadata conflictMetadata, ProtocolMarshaller protocolMarshaller) {
        if (conflictMetadata == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)conflictMetadata.getFilePath(), FILEPATH_BINDING);
            protocolMarshaller.marshall((Object)conflictMetadata.getFileSizes(), FILESIZES_BINDING);
            protocolMarshaller.marshall((Object)conflictMetadata.getFileModes(), FILEMODES_BINDING);
            protocolMarshaller.marshall((Object)conflictMetadata.getObjectTypes(), OBJECTTYPES_BINDING);
            protocolMarshaller.marshall((Object)conflictMetadata.getNumberOfConflicts(), NUMBEROFCONFLICTS_BINDING);
            protocolMarshaller.marshall((Object)conflictMetadata.getIsBinaryFile(), ISBINARYFILE_BINDING);
            protocolMarshaller.marshall((Object)conflictMetadata.getContentConflict(), CONTENTCONFLICT_BINDING);
            protocolMarshaller.marshall((Object)conflictMetadata.getFileModeConflict(), FILEMODECONFLICT_BINDING);
            protocolMarshaller.marshall((Object)conflictMetadata.getObjectTypeConflict(), OBJECTTYPECONFLICT_BINDING);
            protocolMarshaller.marshall((Object)conflictMetadata.getMergeOperations(), MERGEOPERATIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

