/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit.model.transform;

import com.amazonaws.services.codecommit.model.ObjectTypes;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class ObjectTypesJsonUnmarshaller
implements Unmarshaller<ObjectTypes, JsonUnmarshallerContext> {
    private static ObjectTypesJsonUnmarshaller instance;

    public ObjectTypes unmarshall(JsonUnmarshallerContext context) throws Exception {
        ObjectTypes objectTypes = new ObjectTypes();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("source", targetDepth)) {
                    context.nextToken();
                    objectTypes.setSource((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("destination", targetDepth)) {
                    context.nextToken();
                    objectTypes.setDestination((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("base", targetDepth)) {
                    context.nextToken();
                    objectTypes.setBase((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return objectTypes;
    }

    public static ObjectTypesJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ObjectTypesJsonUnmarshaller();
        }
        return instance;
    }
}

