/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.codecommit.model.SourceFileSpecifier;

@SdkInternalApi
public class SourceFileSpecifierMarshaller {
    private static final MarshallingInfo<String> FILEPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("filePath").build();
    private static final MarshallingInfo<Boolean> ISMOVE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("isMove").build();
    private static final SourceFileSpecifierMarshaller instance = new SourceFileSpecifierMarshaller();

    public static SourceFileSpecifierMarshaller getInstance() {
        return instance;
    }

    public void marshall(SourceFileSpecifier sourceFileSpecifier, ProtocolMarshaller protocolMarshaller) {
        if (sourceFileSpecifier == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)sourceFileSpecifier.getFilePath(), FILEPATH_BINDING);
            protocolMarshaller.marshall((Object)sourceFileSpecifier.getIsMove(), ISMOVE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

