/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.cognitoidp.model.IdentityProviderTypeType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateIdentityProviderRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String userPoolId;
    private String providerName;
    private String providerType;
    private Map<String, String> providerDetails;
    private Map<String, String> attributeMapping;
    private List<String> idpIdentifiers;

    public void setUserPoolId(String userPoolId) {
        this.userPoolId = userPoolId;
    }

    public String getUserPoolId() {
        return this.userPoolId;
    }

    public CreateIdentityProviderRequest withUserPoolId(String userPoolId) {
        this.setUserPoolId(userPoolId);
        return this;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public CreateIdentityProviderRequest withProviderName(String providerName) {
        this.setProviderName(providerName);
        return this;
    }

    public void setProviderType(String providerType) {
        this.providerType = providerType;
    }

    public String getProviderType() {
        return this.providerType;
    }

    public CreateIdentityProviderRequest withProviderType(String providerType) {
        this.setProviderType(providerType);
        return this;
    }

    public void setProviderType(IdentityProviderTypeType providerType) {
        this.withProviderType(providerType);
    }

    public CreateIdentityProviderRequest withProviderType(IdentityProviderTypeType providerType) {
        this.providerType = providerType.toString();
        return this;
    }

    public Map<String, String> getProviderDetails() {
        return this.providerDetails;
    }

    public void setProviderDetails(Map<String, String> providerDetails) {
        this.providerDetails = providerDetails;
    }

    public CreateIdentityProviderRequest withProviderDetails(Map<String, String> providerDetails) {
        this.setProviderDetails(providerDetails);
        return this;
    }

    public CreateIdentityProviderRequest addProviderDetailsEntry(String key, String value) {
        if (null == this.providerDetails) {
            this.providerDetails = new HashMap<String, String>();
        }
        if (this.providerDetails.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.providerDetails.put(key, value);
        return this;
    }

    public CreateIdentityProviderRequest clearProviderDetailsEntries() {
        this.providerDetails = null;
        return this;
    }

    public Map<String, String> getAttributeMapping() {
        return this.attributeMapping;
    }

    public void setAttributeMapping(Map<String, String> attributeMapping) {
        this.attributeMapping = attributeMapping;
    }

    public CreateIdentityProviderRequest withAttributeMapping(Map<String, String> attributeMapping) {
        this.setAttributeMapping(attributeMapping);
        return this;
    }

    public CreateIdentityProviderRequest addAttributeMappingEntry(String key, String value) {
        if (null == this.attributeMapping) {
            this.attributeMapping = new HashMap<String, String>();
        }
        if (this.attributeMapping.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.attributeMapping.put(key, value);
        return this;
    }

    public CreateIdentityProviderRequest clearAttributeMappingEntries() {
        this.attributeMapping = null;
        return this;
    }

    public List<String> getIdpIdentifiers() {
        return this.idpIdentifiers;
    }

    public void setIdpIdentifiers(Collection<String> idpIdentifiers) {
        if (idpIdentifiers == null) {
            this.idpIdentifiers = null;
            return;
        }
        this.idpIdentifiers = new ArrayList<String>(idpIdentifiers);
    }

    public CreateIdentityProviderRequest withIdpIdentifiers(String ... idpIdentifiers) {
        if (this.idpIdentifiers == null) {
            this.setIdpIdentifiers(new ArrayList<String>(idpIdentifiers.length));
        }
        for (String ele : idpIdentifiers) {
            this.idpIdentifiers.add(ele);
        }
        return this;
    }

    public CreateIdentityProviderRequest withIdpIdentifiers(Collection<String> idpIdentifiers) {
        this.setIdpIdentifiers(idpIdentifiers);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUserPoolId() != null) {
            sb.append("UserPoolId: ").append(this.getUserPoolId()).append(",");
        }
        if (this.getProviderName() != null) {
            sb.append("ProviderName: ").append(this.getProviderName()).append(",");
        }
        if (this.getProviderType() != null) {
            sb.append("ProviderType: ").append(this.getProviderType()).append(",");
        }
        if (this.getProviderDetails() != null) {
            sb.append("ProviderDetails: ").append(this.getProviderDetails()).append(",");
        }
        if (this.getAttributeMapping() != null) {
            sb.append("AttributeMapping: ").append(this.getAttributeMapping()).append(",");
        }
        if (this.getIdpIdentifiers() != null) {
            sb.append("IdpIdentifiers: ").append(this.getIdpIdentifiers());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIdentityProviderRequest)) {
            return false;
        }
        CreateIdentityProviderRequest other = (CreateIdentityProviderRequest)obj;
        if (other.getUserPoolId() == null ^ this.getUserPoolId() == null) {
            return false;
        }
        if (other.getUserPoolId() != null && !other.getUserPoolId().equals(this.getUserPoolId())) {
            return false;
        }
        if (other.getProviderName() == null ^ this.getProviderName() == null) {
            return false;
        }
        if (other.getProviderName() != null && !other.getProviderName().equals(this.getProviderName())) {
            return false;
        }
        if (other.getProviderType() == null ^ this.getProviderType() == null) {
            return false;
        }
        if (other.getProviderType() != null && !other.getProviderType().equals(this.getProviderType())) {
            return false;
        }
        if (other.getProviderDetails() == null ^ this.getProviderDetails() == null) {
            return false;
        }
        if (other.getProviderDetails() != null && !other.getProviderDetails().equals(this.getProviderDetails())) {
            return false;
        }
        if (other.getAttributeMapping() == null ^ this.getAttributeMapping() == null) {
            return false;
        }
        if (other.getAttributeMapping() != null && !other.getAttributeMapping().equals(this.getAttributeMapping())) {
            return false;
        }
        if (other.getIdpIdentifiers() == null ^ this.getIdpIdentifiers() == null) {
            return false;
        }
        return other.getIdpIdentifiers() == null || other.getIdpIdentifiers().equals(this.getIdpIdentifiers());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUserPoolId() == null ? 0 : this.getUserPoolId().hashCode());
        hashCode = 31 * hashCode + (this.getProviderName() == null ? 0 : this.getProviderName().hashCode());
        hashCode = 31 * hashCode + (this.getProviderType() == null ? 0 : this.getProviderType().hashCode());
        hashCode = 31 * hashCode + (this.getProviderDetails() == null ? 0 : this.getProviderDetails().hashCode());
        hashCode = 31 * hashCode + (this.getAttributeMapping() == null ? 0 : this.getAttributeMapping().hashCode());
        hashCode = 31 * hashCode + (this.getIdpIdentifiers() == null ? 0 : this.getIdpIdentifiers().hashCode());
        return hashCode;
    }

    public CreateIdentityProviderRequest clone() {
        return (CreateIdentityProviderRequest)super.clone();
    }
}

