/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.cognitoidp.model.DeviceType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AdminListDevicesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<DeviceType> devices;
    private String paginationToken;

    public List<DeviceType> getDevices() {
        return this.devices;
    }

    public void setDevices(Collection<DeviceType> devices) {
        if (devices == null) {
            this.devices = null;
            return;
        }
        this.devices = new ArrayList<DeviceType>(devices);
    }

    public AdminListDevicesResult withDevices(DeviceType ... devices) {
        if (this.devices == null) {
            this.setDevices(new ArrayList<DeviceType>(devices.length));
        }
        for (DeviceType ele : devices) {
            this.devices.add(ele);
        }
        return this;
    }

    public AdminListDevicesResult withDevices(Collection<DeviceType> devices) {
        this.setDevices(devices);
        return this;
    }

    public void setPaginationToken(String paginationToken) {
        this.paginationToken = paginationToken;
    }

    public String getPaginationToken() {
        return this.paginationToken;
    }

    public AdminListDevicesResult withPaginationToken(String paginationToken) {
        this.setPaginationToken(paginationToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDevices() != null) {
            sb.append("Devices: ").append(this.getDevices()).append(",");
        }
        if (this.getPaginationToken() != null) {
            sb.append("PaginationToken: ").append(this.getPaginationToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminListDevicesResult)) {
            return false;
        }
        AdminListDevicesResult other = (AdminListDevicesResult)obj;
        if (other.getDevices() == null ^ this.getDevices() == null) {
            return false;
        }
        if (other.getDevices() != null && !other.getDevices().equals(this.getDevices())) {
            return false;
        }
        if (other.getPaginationToken() == null ^ this.getPaginationToken() == null) {
            return false;
        }
        return other.getPaginationToken() == null || other.getPaginationToken().equals(this.getPaginationToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDevices() == null ? 0 : this.getDevices().hashCode());
        hashCode = 31 * hashCode + (this.getPaginationToken() == null ? 0 : this.getPaginationToken().hashCode());
        return hashCode;
    }

    public AdminListDevicesResult clone() {
        try {
            return (AdminListDevicesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

