/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.cognitosync.AmazonCognitoSyncAsync;
import com.amazonaws.services.cognitosync.AmazonCognitoSyncAsyncClientBuilder;
import com.amazonaws.services.cognitosync.AmazonCognitoSyncClient;
import com.amazonaws.services.cognitosync.model.BulkPublishRequest;
import com.amazonaws.services.cognitosync.model.BulkPublishResult;
import com.amazonaws.services.cognitosync.model.DeleteDatasetRequest;
import com.amazonaws.services.cognitosync.model.DeleteDatasetResult;
import com.amazonaws.services.cognitosync.model.DescribeDatasetRequest;
import com.amazonaws.services.cognitosync.model.DescribeDatasetResult;
import com.amazonaws.services.cognitosync.model.DescribeIdentityPoolUsageRequest;
import com.amazonaws.services.cognitosync.model.DescribeIdentityPoolUsageResult;
import com.amazonaws.services.cognitosync.model.DescribeIdentityUsageRequest;
import com.amazonaws.services.cognitosync.model.DescribeIdentityUsageResult;
import com.amazonaws.services.cognitosync.model.GetBulkPublishDetailsRequest;
import com.amazonaws.services.cognitosync.model.GetBulkPublishDetailsResult;
import com.amazonaws.services.cognitosync.model.GetCognitoEventsRequest;
import com.amazonaws.services.cognitosync.model.GetCognitoEventsResult;
import com.amazonaws.services.cognitosync.model.GetIdentityPoolConfigurationRequest;
import com.amazonaws.services.cognitosync.model.GetIdentityPoolConfigurationResult;
import com.amazonaws.services.cognitosync.model.ListDatasetsRequest;
import com.amazonaws.services.cognitosync.model.ListDatasetsResult;
import com.amazonaws.services.cognitosync.model.ListIdentityPoolUsageRequest;
import com.amazonaws.services.cognitosync.model.ListIdentityPoolUsageResult;
import com.amazonaws.services.cognitosync.model.ListRecordsRequest;
import com.amazonaws.services.cognitosync.model.ListRecordsResult;
import com.amazonaws.services.cognitosync.model.RegisterDeviceRequest;
import com.amazonaws.services.cognitosync.model.RegisterDeviceResult;
import com.amazonaws.services.cognitosync.model.SetCognitoEventsRequest;
import com.amazonaws.services.cognitosync.model.SetCognitoEventsResult;
import com.amazonaws.services.cognitosync.model.SetIdentityPoolConfigurationRequest;
import com.amazonaws.services.cognitosync.model.SetIdentityPoolConfigurationResult;
import com.amazonaws.services.cognitosync.model.SubscribeToDatasetRequest;
import com.amazonaws.services.cognitosync.model.SubscribeToDatasetResult;
import com.amazonaws.services.cognitosync.model.UnsubscribeFromDatasetRequest;
import com.amazonaws.services.cognitosync.model.UnsubscribeFromDatasetResult;
import com.amazonaws.services.cognitosync.model.UpdateRecordsRequest;
import com.amazonaws.services.cognitosync.model.UpdateRecordsResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonCognitoSyncAsyncClient
extends AmazonCognitoSyncClient
implements AmazonCognitoSyncAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AmazonCognitoSyncAsyncClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AmazonCognitoSyncAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonCognitoSyncAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonCognitoSyncAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonCognitoSyncAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AmazonCognitoSyncAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonCognitoSyncAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonCognitoSyncAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonCognitoSyncAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AmazonCognitoSyncAsyncClientBuilder asyncBuilder() {
        return AmazonCognitoSyncAsyncClientBuilder.standard();
    }

    AmazonCognitoSyncAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonCognitoSyncAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<BulkPublishResult> bulkPublishAsync(BulkPublishRequest request) {
        return this.bulkPublishAsync(request, null);
    }

    @Override
    public Future<BulkPublishResult> bulkPublishAsync(BulkPublishRequest request, final AsyncHandler<BulkPublishRequest, BulkPublishResult> asyncHandler) {
        final BulkPublishRequest finalRequest = (BulkPublishRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BulkPublishResult>(){

            @Override
            public BulkPublishResult call() throws Exception {
                BulkPublishResult result = null;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.executeBulkPublish(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDatasetResult> deleteDatasetAsync(DeleteDatasetRequest request) {
        return this.deleteDatasetAsync(request, null);
    }

    @Override
    public Future<DeleteDatasetResult> deleteDatasetAsync(DeleteDatasetRequest request, final AsyncHandler<DeleteDatasetRequest, DeleteDatasetResult> asyncHandler) {
        final DeleteDatasetRequest finalRequest = (DeleteDatasetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteDatasetResult>(){

            @Override
            public DeleteDatasetResult call() throws Exception {
                DeleteDatasetResult result = null;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.executeDeleteDataset(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDatasetResult> describeDatasetAsync(DescribeDatasetRequest request) {
        return this.describeDatasetAsync(request, null);
    }

    @Override
    public Future<DescribeDatasetResult> describeDatasetAsync(DescribeDatasetRequest request, final AsyncHandler<DescribeDatasetRequest, DescribeDatasetResult> asyncHandler) {
        final DescribeDatasetRequest finalRequest = (DescribeDatasetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDatasetResult>(){

            @Override
            public DescribeDatasetResult call() throws Exception {
                DescribeDatasetResult result = null;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.executeDescribeDataset(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeIdentityPoolUsageResult> describeIdentityPoolUsageAsync(DescribeIdentityPoolUsageRequest request) {
        return this.describeIdentityPoolUsageAsync(request, null);
    }

    @Override
    public Future<DescribeIdentityPoolUsageResult> describeIdentityPoolUsageAsync(DescribeIdentityPoolUsageRequest request, final AsyncHandler<DescribeIdentityPoolUsageRequest, DescribeIdentityPoolUsageResult> asyncHandler) {
        final DescribeIdentityPoolUsageRequest finalRequest = (DescribeIdentityPoolUsageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeIdentityPoolUsageResult>(){

            @Override
            public DescribeIdentityPoolUsageResult call() throws Exception {
                DescribeIdentityPoolUsageResult result = null;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.executeDescribeIdentityPoolUsage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeIdentityUsageResult> describeIdentityUsageAsync(DescribeIdentityUsageRequest request) {
        return this.describeIdentityUsageAsync(request, null);
    }

    @Override
    public Future<DescribeIdentityUsageResult> describeIdentityUsageAsync(DescribeIdentityUsageRequest request, final AsyncHandler<DescribeIdentityUsageRequest, DescribeIdentityUsageResult> asyncHandler) {
        final DescribeIdentityUsageRequest finalRequest = (DescribeIdentityUsageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeIdentityUsageResult>(){

            @Override
            public DescribeIdentityUsageResult call() throws Exception {
                DescribeIdentityUsageResult result = null;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.executeDescribeIdentityUsage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetBulkPublishDetailsResult> getBulkPublishDetailsAsync(GetBulkPublishDetailsRequest request) {
        return this.getBulkPublishDetailsAsync(request, null);
    }

    @Override
    public Future<GetBulkPublishDetailsResult> getBulkPublishDetailsAsync(GetBulkPublishDetailsRequest request, final AsyncHandler<GetBulkPublishDetailsRequest, GetBulkPublishDetailsResult> asyncHandler) {
        final GetBulkPublishDetailsRequest finalRequest = (GetBulkPublishDetailsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetBulkPublishDetailsResult>(){

            @Override
            public GetBulkPublishDetailsResult call() throws Exception {
                GetBulkPublishDetailsResult result = null;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.executeGetBulkPublishDetails(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCognitoEventsResult> getCognitoEventsAsync(GetCognitoEventsRequest request) {
        return this.getCognitoEventsAsync(request, null);
    }

    @Override
    public Future<GetCognitoEventsResult> getCognitoEventsAsync(GetCognitoEventsRequest request, final AsyncHandler<GetCognitoEventsRequest, GetCognitoEventsResult> asyncHandler) {
        final GetCognitoEventsRequest finalRequest = (GetCognitoEventsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetCognitoEventsResult>(){

            @Override
            public GetCognitoEventsResult call() throws Exception {
                GetCognitoEventsResult result = null;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.executeGetCognitoEvents(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetIdentityPoolConfigurationResult> getIdentityPoolConfigurationAsync(GetIdentityPoolConfigurationRequest request) {
        return this.getIdentityPoolConfigurationAsync(request, null);
    }

    @Override
    public Future<GetIdentityPoolConfigurationResult> getIdentityPoolConfigurationAsync(GetIdentityPoolConfigurationRequest request, final AsyncHandler<GetIdentityPoolConfigurationRequest, GetIdentityPoolConfigurationResult> asyncHandler) {
        final GetIdentityPoolConfigurationRequest finalRequest = (GetIdentityPoolConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetIdentityPoolConfigurationResult>(){

            @Override
            public GetIdentityPoolConfigurationResult call() throws Exception {
                GetIdentityPoolConfigurationResult result = null;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.executeGetIdentityPoolConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDatasetsResult> listDatasetsAsync(ListDatasetsRequest request) {
        return this.listDatasetsAsync(request, null);
    }

    @Override
    public Future<ListDatasetsResult> listDatasetsAsync(ListDatasetsRequest request, final AsyncHandler<ListDatasetsRequest, ListDatasetsResult> asyncHandler) {
        final ListDatasetsRequest finalRequest = (ListDatasetsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDatasetsResult>(){

            @Override
            public ListDatasetsResult call() throws Exception {
                ListDatasetsResult result = null;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.executeListDatasets(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListIdentityPoolUsageResult> listIdentityPoolUsageAsync(ListIdentityPoolUsageRequest request) {
        return this.listIdentityPoolUsageAsync(request, null);
    }

    @Override
    public Future<ListIdentityPoolUsageResult> listIdentityPoolUsageAsync(ListIdentityPoolUsageRequest request, final AsyncHandler<ListIdentityPoolUsageRequest, ListIdentityPoolUsageResult> asyncHandler) {
        final ListIdentityPoolUsageRequest finalRequest = (ListIdentityPoolUsageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListIdentityPoolUsageResult>(){

            @Override
            public ListIdentityPoolUsageResult call() throws Exception {
                ListIdentityPoolUsageResult result = null;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.executeListIdentityPoolUsage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListRecordsResult> listRecordsAsync(ListRecordsRequest request) {
        return this.listRecordsAsync(request, null);
    }

    @Override
    public Future<ListRecordsResult> listRecordsAsync(ListRecordsRequest request, final AsyncHandler<ListRecordsRequest, ListRecordsResult> asyncHandler) {
        final ListRecordsRequest finalRequest = (ListRecordsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListRecordsResult>(){

            @Override
            public ListRecordsResult call() throws Exception {
                ListRecordsResult result = null;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.executeListRecords(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RegisterDeviceResult> registerDeviceAsync(RegisterDeviceRequest request) {
        return this.registerDeviceAsync(request, null);
    }

    @Override
    public Future<RegisterDeviceResult> registerDeviceAsync(RegisterDeviceRequest request, final AsyncHandler<RegisterDeviceRequest, RegisterDeviceResult> asyncHandler) {
        final RegisterDeviceRequest finalRequest = (RegisterDeviceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RegisterDeviceResult>(){

            @Override
            public RegisterDeviceResult call() throws Exception {
                RegisterDeviceResult result = null;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.executeRegisterDevice(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SetCognitoEventsResult> setCognitoEventsAsync(SetCognitoEventsRequest request) {
        return this.setCognitoEventsAsync(request, null);
    }

    @Override
    public Future<SetCognitoEventsResult> setCognitoEventsAsync(SetCognitoEventsRequest request, final AsyncHandler<SetCognitoEventsRequest, SetCognitoEventsResult> asyncHandler) {
        final SetCognitoEventsRequest finalRequest = (SetCognitoEventsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SetCognitoEventsResult>(){

            @Override
            public SetCognitoEventsResult call() throws Exception {
                SetCognitoEventsResult result = null;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.executeSetCognitoEvents(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SetIdentityPoolConfigurationResult> setIdentityPoolConfigurationAsync(SetIdentityPoolConfigurationRequest request) {
        return this.setIdentityPoolConfigurationAsync(request, null);
    }

    @Override
    public Future<SetIdentityPoolConfigurationResult> setIdentityPoolConfigurationAsync(SetIdentityPoolConfigurationRequest request, final AsyncHandler<SetIdentityPoolConfigurationRequest, SetIdentityPoolConfigurationResult> asyncHandler) {
        final SetIdentityPoolConfigurationRequest finalRequest = (SetIdentityPoolConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SetIdentityPoolConfigurationResult>(){

            @Override
            public SetIdentityPoolConfigurationResult call() throws Exception {
                SetIdentityPoolConfigurationResult result = null;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.executeSetIdentityPoolConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SubscribeToDatasetResult> subscribeToDatasetAsync(SubscribeToDatasetRequest request) {
        return this.subscribeToDatasetAsync(request, null);
    }

    @Override
    public Future<SubscribeToDatasetResult> subscribeToDatasetAsync(SubscribeToDatasetRequest request, final AsyncHandler<SubscribeToDatasetRequest, SubscribeToDatasetResult> asyncHandler) {
        final SubscribeToDatasetRequest finalRequest = (SubscribeToDatasetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SubscribeToDatasetResult>(){

            @Override
            public SubscribeToDatasetResult call() throws Exception {
                SubscribeToDatasetResult result = null;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.executeSubscribeToDataset(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UnsubscribeFromDatasetResult> unsubscribeFromDatasetAsync(UnsubscribeFromDatasetRequest request) {
        return this.unsubscribeFromDatasetAsync(request, null);
    }

    @Override
    public Future<UnsubscribeFromDatasetResult> unsubscribeFromDatasetAsync(UnsubscribeFromDatasetRequest request, final AsyncHandler<UnsubscribeFromDatasetRequest, UnsubscribeFromDatasetResult> asyncHandler) {
        final UnsubscribeFromDatasetRequest finalRequest = (UnsubscribeFromDatasetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UnsubscribeFromDatasetResult>(){

            @Override
            public UnsubscribeFromDatasetResult call() throws Exception {
                UnsubscribeFromDatasetResult result = null;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.executeUnsubscribeFromDataset(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateRecordsResult> updateRecordsAsync(UpdateRecordsRequest request) {
        return this.updateRecordsAsync(request, null);
    }

    @Override
    public Future<UpdateRecordsResult> updateRecordsAsync(UpdateRecordsRequest request, final AsyncHandler<UpdateRecordsRequest, UpdateRecordsResult> asyncHandler) {
        final UpdateRecordsRequest finalRequest = (UpdateRecordsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateRecordsResult>(){

            @Override
            public UpdateRecordsResult call() throws Exception {
                UpdateRecordsResult result = null;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.executeUpdateRecords(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

