/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.comprehend.model.transform;

import java.util.List;
import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.comprehend.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * AugmentedManifestsListItemMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class AugmentedManifestsListItemMarshaller {

    private static final MarshallingInfo<String> S3URI_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("S3Uri").build();
    private static final MarshallingInfo<String> SPLIT_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Split").build();
    private static final MarshallingInfo<List> ATTRIBUTENAMES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttributeNames").build();
    private static final MarshallingInfo<String> ANNOTATIONDATAS3URI_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AnnotationDataS3Uri").build();
    private static final MarshallingInfo<String> SOURCEDOCUMENTSS3URI_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceDocumentsS3Uri").build();
    private static final MarshallingInfo<String> DOCUMENTTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentType").build();

    private static final AugmentedManifestsListItemMarshaller instance = new AugmentedManifestsListItemMarshaller();

    public static AugmentedManifestsListItemMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(AugmentedManifestsListItem augmentedManifestsListItem, ProtocolMarshaller protocolMarshaller) {

        if (augmentedManifestsListItem == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(augmentedManifestsListItem.getS3Uri(), S3URI_BINDING);
            protocolMarshaller.marshall(augmentedManifestsListItem.getSplit(), SPLIT_BINDING);
            protocolMarshaller.marshall(augmentedManifestsListItem.getAttributeNames(), ATTRIBUTENAMES_BINDING);
            protocolMarshaller.marshall(augmentedManifestsListItem.getAnnotationDataS3Uri(), ANNOTATIONDATAS3URI_BINDING);
            protocolMarshaller.marshall(augmentedManifestsListItem.getSourceDocumentsS3Uri(), SOURCEDOCUMENTSS3URI_BINDING);
            protocolMarshaller.marshall(augmentedManifestsListItem.getDocumentType(), DOCUMENTTYPE_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
