/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.config.model.transform;

import java.util.List;
import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.config.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * OrganizationConfigRuleMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class OrganizationConfigRuleMarshaller {

    private static final MarshallingInfo<String> ORGANIZATIONCONFIGRULENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OrganizationConfigRuleName").build();
    private static final MarshallingInfo<String> ORGANIZATIONCONFIGRULEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OrganizationConfigRuleArn").build();
    private static final MarshallingInfo<StructuredPojo> ORGANIZATIONMANAGEDRULEMETADATA_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OrganizationManagedRuleMetadata").build();
    private static final MarshallingInfo<StructuredPojo> ORGANIZATIONCUSTOMRULEMETADATA_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OrganizationCustomRuleMetadata").build();
    private static final MarshallingInfo<List> EXCLUDEDACCOUNTS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExcludedAccounts").build();
    private static final MarshallingInfo<java.util.Date> LASTUPDATETIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdateTime").timestampFormat("unixTimestamp").build();

    private static final OrganizationConfigRuleMarshaller instance = new OrganizationConfigRuleMarshaller();

    public static OrganizationConfigRuleMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(OrganizationConfigRule organizationConfigRule, ProtocolMarshaller protocolMarshaller) {

        if (organizationConfigRule == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(organizationConfigRule.getOrganizationConfigRuleName(), ORGANIZATIONCONFIGRULENAME_BINDING);
            protocolMarshaller.marshall(organizationConfigRule.getOrganizationConfigRuleArn(), ORGANIZATIONCONFIGRULEARN_BINDING);
            protocolMarshaller.marshall(organizationConfigRule.getOrganizationManagedRuleMetadata(), ORGANIZATIONMANAGEDRULEMETADATA_BINDING);
            protocolMarshaller.marshall(organizationConfigRule.getOrganizationCustomRuleMetadata(), ORGANIZATIONCUSTOMRULEMETADATA_BINDING);
            protocolMarshaller.marshall(organizationConfigRule.getExcludedAccounts(), EXCLUDEDACCOUNTS_BINDING);
            protocolMarshaller.marshall(organizationConfigRule.getLastUpdateTime(), LASTUPDATETIME_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
