/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.config.model.ConfigRule;
import com.amazonaws.services.config.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class PutConfigRuleRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private ConfigRule configRule;
    private SdkInternalList<Tag> tags;

    public void setConfigRule(ConfigRule configRule) {
        this.configRule = configRule;
    }

    public ConfigRule getConfigRule() {
        return this.configRule;
    }

    public PutConfigRuleRequest withConfigRule(ConfigRule configRule) {
        this.setConfigRule(configRule);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public PutConfigRuleRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public PutConfigRuleRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getConfigRule() != null) {
            sb.append("ConfigRule: ").append(this.getConfigRule()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutConfigRuleRequest)) {
            return false;
        }
        PutConfigRuleRequest other = (PutConfigRuleRequest)obj;
        if (other.getConfigRule() == null ^ this.getConfigRule() == null) {
            return false;
        }
        if (other.getConfigRule() != null && !other.getConfigRule().equals(this.getConfigRule())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getConfigRule() == null ? 0 : this.getConfigRule().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public PutConfigRuleRequest clone() {
        return (PutConfigRuleRequest)super.clone();
    }
}

