/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.config.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Filters the results based on account ID and region.
 * </p>
 * 
 * @see <a
 *      href="http://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/AggregateConformancePackComplianceSummaryFilters"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AggregateConformancePackComplianceSummaryFilters implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The 12-digit Amazon Web Services account ID of the source account.
     * </p>
     */
    private String accountId;
    /**
     * <p>
     * The source Amazon Web Services Region from where the data is aggregated.
     * </p>
     */
    private String awsRegion;

    /**
     * <p>
     * The 12-digit Amazon Web Services account ID of the source account.
     * </p>
     * 
     * @param accountId
     *        The 12-digit Amazon Web Services account ID of the source account.
     */

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    /**
     * <p>
     * The 12-digit Amazon Web Services account ID of the source account.
     * </p>
     * 
     * @return The 12-digit Amazon Web Services account ID of the source account.
     */

    public String getAccountId() {
        return this.accountId;
    }

    /**
     * <p>
     * The 12-digit Amazon Web Services account ID of the source account.
     * </p>
     * 
     * @param accountId
     *        The 12-digit Amazon Web Services account ID of the source account.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AggregateConformancePackComplianceSummaryFilters withAccountId(String accountId) {
        setAccountId(accountId);
        return this;
    }

    /**
     * <p>
     * The source Amazon Web Services Region from where the data is aggregated.
     * </p>
     * 
     * @param awsRegion
     *        The source Amazon Web Services Region from where the data is aggregated.
     */

    public void setAwsRegion(String awsRegion) {
        this.awsRegion = awsRegion;
    }

    /**
     * <p>
     * The source Amazon Web Services Region from where the data is aggregated.
     * </p>
     * 
     * @return The source Amazon Web Services Region from where the data is aggregated.
     */

    public String getAwsRegion() {
        return this.awsRegion;
    }

    /**
     * <p>
     * The source Amazon Web Services Region from where the data is aggregated.
     * </p>
     * 
     * @param awsRegion
     *        The source Amazon Web Services Region from where the data is aggregated.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AggregateConformancePackComplianceSummaryFilters withAwsRegion(String awsRegion) {
        setAwsRegion(awsRegion);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAccountId() != null)
            sb.append("AccountId: ").append(getAccountId()).append(",");
        if (getAwsRegion() != null)
            sb.append("AwsRegion: ").append(getAwsRegion());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof AggregateConformancePackComplianceSummaryFilters == false)
            return false;
        AggregateConformancePackComplianceSummaryFilters other = (AggregateConformancePackComplianceSummaryFilters) obj;
        if (other.getAccountId() == null ^ this.getAccountId() == null)
            return false;
        if (other.getAccountId() != null && other.getAccountId().equals(this.getAccountId()) == false)
            return false;
        if (other.getAwsRegion() == null ^ this.getAwsRegion() == null)
            return false;
        if (other.getAwsRegion() != null && other.getAwsRegion().equals(this.getAwsRegion()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAccountId() == null) ? 0 : getAccountId().hashCode());
        hashCode = prime * hashCode + ((getAwsRegion() == null) ? 0 : getAwsRegion().hashCode());
        return hashCode;
    }

    @Override
    public AggregateConformancePackComplianceSummaryFilters clone() {
        try {
            return (AggregateConformancePackComplianceSummaryFilters) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.config.model.transform.AggregateConformancePackComplianceSummaryFiltersMarshaller.getInstance().marshall(this,
                protocolMarshaller);
    }
}
