/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.config.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * An object that represents the details about the remediation exception. The details include the rule name, an
 * explanation of an exception, the time when the exception will be deleted, the resource ID, and resource type.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/RemediationException" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class RemediationException implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The name of the Config rule.
     * </p>
     */
    private String configRuleName;
    /**
     * <p>
     * The type of a resource.
     * </p>
     */
    private String resourceType;
    /**
     * <p>
     * The ID of the resource (for example., sg-xxxxxx).
     * </p>
     */
    private String resourceId;
    /**
     * <p>
     * An explanation of an remediation exception.
     * </p>
     */
    private String message;
    /**
     * <p>
     * The time when the remediation exception will be deleted.
     * </p>
     */
    private java.util.Date expirationTime;

    /**
     * <p>
     * The name of the Config rule.
     * </p>
     * 
     * @param configRuleName
     *        The name of the Config rule.
     */

    public void setConfigRuleName(String configRuleName) {
        this.configRuleName = configRuleName;
    }

    /**
     * <p>
     * The name of the Config rule.
     * </p>
     * 
     * @return The name of the Config rule.
     */

    public String getConfigRuleName() {
        return this.configRuleName;
    }

    /**
     * <p>
     * The name of the Config rule.
     * </p>
     * 
     * @param configRuleName
     *        The name of the Config rule.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RemediationException withConfigRuleName(String configRuleName) {
        setConfigRuleName(configRuleName);
        return this;
    }

    /**
     * <p>
     * The type of a resource.
     * </p>
     * 
     * @param resourceType
     *        The type of a resource.
     */

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    /**
     * <p>
     * The type of a resource.
     * </p>
     * 
     * @return The type of a resource.
     */

    public String getResourceType() {
        return this.resourceType;
    }

    /**
     * <p>
     * The type of a resource.
     * </p>
     * 
     * @param resourceType
     *        The type of a resource.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RemediationException withResourceType(String resourceType) {
        setResourceType(resourceType);
        return this;
    }

    /**
     * <p>
     * The ID of the resource (for example., sg-xxxxxx).
     * </p>
     * 
     * @param resourceId
     *        The ID of the resource (for example., sg-xxxxxx).
     */

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    /**
     * <p>
     * The ID of the resource (for example., sg-xxxxxx).
     * </p>
     * 
     * @return The ID of the resource (for example., sg-xxxxxx).
     */

    public String getResourceId() {
        return this.resourceId;
    }

    /**
     * <p>
     * The ID of the resource (for example., sg-xxxxxx).
     * </p>
     * 
     * @param resourceId
     *        The ID of the resource (for example., sg-xxxxxx).
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RemediationException withResourceId(String resourceId) {
        setResourceId(resourceId);
        return this;
    }

    /**
     * <p>
     * An explanation of an remediation exception.
     * </p>
     * 
     * @param message
     *        An explanation of an remediation exception.
     */

    public void setMessage(String message) {
        this.message = message;
    }

    /**
     * <p>
     * An explanation of an remediation exception.
     * </p>
     * 
     * @return An explanation of an remediation exception.
     */

    public String getMessage() {
        return this.message;
    }

    /**
     * <p>
     * An explanation of an remediation exception.
     * </p>
     * 
     * @param message
     *        An explanation of an remediation exception.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RemediationException withMessage(String message) {
        setMessage(message);
        return this;
    }

    /**
     * <p>
     * The time when the remediation exception will be deleted.
     * </p>
     * 
     * @param expirationTime
     *        The time when the remediation exception will be deleted.
     */

    public void setExpirationTime(java.util.Date expirationTime) {
        this.expirationTime = expirationTime;
    }

    /**
     * <p>
     * The time when the remediation exception will be deleted.
     * </p>
     * 
     * @return The time when the remediation exception will be deleted.
     */

    public java.util.Date getExpirationTime() {
        return this.expirationTime;
    }

    /**
     * <p>
     * The time when the remediation exception will be deleted.
     * </p>
     * 
     * @param expirationTime
     *        The time when the remediation exception will be deleted.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RemediationException withExpirationTime(java.util.Date expirationTime) {
        setExpirationTime(expirationTime);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getConfigRuleName() != null)
            sb.append("ConfigRuleName: ").append(getConfigRuleName()).append(",");
        if (getResourceType() != null)
            sb.append("ResourceType: ").append(getResourceType()).append(",");
        if (getResourceId() != null)
            sb.append("ResourceId: ").append(getResourceId()).append(",");
        if (getMessage() != null)
            sb.append("Message: ").append(getMessage()).append(",");
        if (getExpirationTime() != null)
            sb.append("ExpirationTime: ").append(getExpirationTime());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof RemediationException == false)
            return false;
        RemediationException other = (RemediationException) obj;
        if (other.getConfigRuleName() == null ^ this.getConfigRuleName() == null)
            return false;
        if (other.getConfigRuleName() != null && other.getConfigRuleName().equals(this.getConfigRuleName()) == false)
            return false;
        if (other.getResourceType() == null ^ this.getResourceType() == null)
            return false;
        if (other.getResourceType() != null && other.getResourceType().equals(this.getResourceType()) == false)
            return false;
        if (other.getResourceId() == null ^ this.getResourceId() == null)
            return false;
        if (other.getResourceId() != null && other.getResourceId().equals(this.getResourceId()) == false)
            return false;
        if (other.getMessage() == null ^ this.getMessage() == null)
            return false;
        if (other.getMessage() != null && other.getMessage().equals(this.getMessage()) == false)
            return false;
        if (other.getExpirationTime() == null ^ this.getExpirationTime() == null)
            return false;
        if (other.getExpirationTime() != null && other.getExpirationTime().equals(this.getExpirationTime()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getConfigRuleName() == null) ? 0 : getConfigRuleName().hashCode());
        hashCode = prime * hashCode + ((getResourceType() == null) ? 0 : getResourceType().hashCode());
        hashCode = prime * hashCode + ((getResourceId() == null) ? 0 : getResourceId().hashCode());
        hashCode = prime * hashCode + ((getMessage() == null) ? 0 : getMessage().hashCode());
        hashCode = prime * hashCode + ((getExpirationTime() == null) ? 0 : getExpirationTime().hashCode());
        return hashCode;
    }

    @Override
    public RemediationException clone() {
        try {
            return (RemediationException) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.config.model.transform.RemediationExceptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
