/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.connect.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListQueues" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListQueuesRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The identifier of the Amazon Connect instance.
     * </p>
     */
    private String instanceId;
    /**
     * <p>
     * The type of queue.
     * </p>
     */
    private java.util.List<String> queueTypes;
    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results.
     * </p>
     */
    private String nextToken;
    /**
     * <p>
     * The maximimum number of results to return per page.
     * </p>
     */
    private Integer maxResults;

    /**
     * <p>
     * The identifier of the Amazon Connect instance.
     * </p>
     * 
     * @param instanceId
     *        The identifier of the Amazon Connect instance.
     */

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance.
     */

    public String getInstanceId() {
        return this.instanceId;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance.
     * </p>
     * 
     * @param instanceId
     *        The identifier of the Amazon Connect instance.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListQueuesRequest withInstanceId(String instanceId) {
        setInstanceId(instanceId);
        return this;
    }

    /**
     * <p>
     * The type of queue.
     * </p>
     * 
     * @return The type of queue.
     * @see QueueType
     */

    public java.util.List<String> getQueueTypes() {
        return queueTypes;
    }

    /**
     * <p>
     * The type of queue.
     * </p>
     * 
     * @param queueTypes
     *        The type of queue.
     * @see QueueType
     */

    public void setQueueTypes(java.util.Collection<String> queueTypes) {
        if (queueTypes == null) {
            this.queueTypes = null;
            return;
        }

        this.queueTypes = new java.util.ArrayList<String>(queueTypes);
    }

    /**
     * <p>
     * The type of queue.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setQueueTypes(java.util.Collection)} or {@link #withQueueTypes(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param queueTypes
     *        The type of queue.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see QueueType
     */

    public ListQueuesRequest withQueueTypes(String... queueTypes) {
        if (this.queueTypes == null) {
            setQueueTypes(new java.util.ArrayList<String>(queueTypes.length));
        }
        for (String ele : queueTypes) {
            this.queueTypes.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The type of queue.
     * </p>
     * 
     * @param queueTypes
     *        The type of queue.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see QueueType
     */

    public ListQueuesRequest withQueueTypes(java.util.Collection<String> queueTypes) {
        setQueueTypes(queueTypes);
        return this;
    }

    /**
     * <p>
     * The type of queue.
     * </p>
     * 
     * @param queueTypes
     *        The type of queue.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see QueueType
     */

    public ListQueuesRequest withQueueTypes(QueueType... queueTypes) {
        java.util.ArrayList<String> queueTypesCopy = new java.util.ArrayList<String>(queueTypes.length);
        for (QueueType value : queueTypes) {
            queueTypesCopy.add(value.toString());
        }
        if (getQueueTypes() == null) {
            setQueueTypes(queueTypesCopy);
        } else {
            getQueueTypes().addAll(queueTypesCopy);
        }
        return this;
    }

    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results.
     * </p>
     * 
     * @param nextToken
     *        The token for the next set of results. Use the value returned in the previous response in the next request
     *        to retrieve the next set of results.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results.
     * </p>
     * 
     * @return The token for the next set of results. Use the value returned in the previous response in the next
     *         request to retrieve the next set of results.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results.
     * </p>
     * 
     * @param nextToken
     *        The token for the next set of results. Use the value returned in the previous response in the next request
     *        to retrieve the next set of results.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListQueuesRequest withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * <p>
     * The maximimum number of results to return per page.
     * </p>
     * 
     * @param maxResults
     *        The maximimum number of results to return per page.
     */

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    /**
     * <p>
     * The maximimum number of results to return per page.
     * </p>
     * 
     * @return The maximimum number of results to return per page.
     */

    public Integer getMaxResults() {
        return this.maxResults;
    }

    /**
     * <p>
     * The maximimum number of results to return per page.
     * </p>
     * 
     * @param maxResults
     *        The maximimum number of results to return per page.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListQueuesRequest withMaxResults(Integer maxResults) {
        setMaxResults(maxResults);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getInstanceId() != null)
            sb.append("InstanceId: ").append(getInstanceId()).append(",");
        if (getQueueTypes() != null)
            sb.append("QueueTypes: ").append(getQueueTypes()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken()).append(",");
        if (getMaxResults() != null)
            sb.append("MaxResults: ").append(getMaxResults());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListQueuesRequest == false)
            return false;
        ListQueuesRequest other = (ListQueuesRequest) obj;
        if (other.getInstanceId() == null ^ this.getInstanceId() == null)
            return false;
        if (other.getInstanceId() != null && other.getInstanceId().equals(this.getInstanceId()) == false)
            return false;
        if (other.getQueueTypes() == null ^ this.getQueueTypes() == null)
            return false;
        if (other.getQueueTypes() != null && other.getQueueTypes().equals(this.getQueueTypes()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        if (other.getMaxResults() == null ^ this.getMaxResults() == null)
            return false;
        if (other.getMaxResults() != null && other.getMaxResults().equals(this.getMaxResults()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getInstanceId() == null) ? 0 : getInstanceId().hashCode());
        hashCode = prime * hashCode + ((getQueueTypes() == null) ? 0 : getQueueTypes().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        hashCode = prime * hashCode + ((getMaxResults() == null) ? 0 : getMaxResults().hashCode());
        return hashCode;
    }

    @Override
    public ListQueuesRequest clone() {
        return (ListQueuesRequest) super.clone();
    }

}
