/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.connect.model.transform;

import java.util.Map;
import java.util.List;
import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.connect.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * RoutingProfileMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class RoutingProfileMarshaller {

    private static final MarshallingInfo<String> INSTANCEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceId").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Name").build();
    private static final MarshallingInfo<String> ROUTINGPROFILEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoutingProfileArn").build();
    private static final MarshallingInfo<String> ROUTINGPROFILEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoutingProfileId").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<List> MEDIACONCURRENCIES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MediaConcurrencies").build();
    private static final MarshallingInfo<String> DEFAULTOUTBOUNDQUEUEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultOutboundQueueId").build();
    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Tags").build();
    private static final MarshallingInfo<Long> NUMBEROFASSOCIATEDQUEUES_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumberOfAssociatedQueues").build();
    private static final MarshallingInfo<Long> NUMBEROFASSOCIATEDUSERS_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumberOfAssociatedUsers").build();

    private static final RoutingProfileMarshaller instance = new RoutingProfileMarshaller();

    public static RoutingProfileMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(RoutingProfile routingProfile, ProtocolMarshaller protocolMarshaller) {

        if (routingProfile == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(routingProfile.getInstanceId(), INSTANCEID_BINDING);
            protocolMarshaller.marshall(routingProfile.getName(), NAME_BINDING);
            protocolMarshaller.marshall(routingProfile.getRoutingProfileArn(), ROUTINGPROFILEARN_BINDING);
            protocolMarshaller.marshall(routingProfile.getRoutingProfileId(), ROUTINGPROFILEID_BINDING);
            protocolMarshaller.marshall(routingProfile.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(routingProfile.getMediaConcurrencies(), MEDIACONCURRENCIES_BINDING);
            protocolMarshaller.marshall(routingProfile.getDefaultOutboundQueueId(), DEFAULTOUTBOUNDQUEUEID_BINDING);
            protocolMarshaller.marshall(routingProfile.getTags(), TAGS_BINDING);
            protocolMarshaller.marshall(routingProfile.getNumberOfAssociatedQueues(), NUMBEROFASSOCIATEDQUEUES_BINDING);
            protocolMarshaller.marshall(routingProfile.getNumberOfAssociatedUsers(), NUMBEROFASSOCIATEDUSERS_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
