/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpdateSecurityProfileRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String description;
    private List<String> permissions;
    private String securityProfileId;
    private String instanceId;
    private Map<String, String> allowedAccessControlTags;
    private List<String> tagRestrictedResources;

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public UpdateSecurityProfileRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Collection<String> permissions) {
        if (permissions == null) {
            this.permissions = null;
            return;
        }
        this.permissions = new ArrayList<String>(permissions);
    }

    public UpdateSecurityProfileRequest withPermissions(String ... permissions) {
        if (this.permissions == null) {
            this.setPermissions(new ArrayList<String>(permissions.length));
        }
        for (String ele : permissions) {
            this.permissions.add(ele);
        }
        return this;
    }

    public UpdateSecurityProfileRequest withPermissions(Collection<String> permissions) {
        this.setPermissions(permissions);
        return this;
    }

    public void setSecurityProfileId(String securityProfileId) {
        this.securityProfileId = securityProfileId;
    }

    public String getSecurityProfileId() {
        return this.securityProfileId;
    }

    public UpdateSecurityProfileRequest withSecurityProfileId(String securityProfileId) {
        this.setSecurityProfileId(securityProfileId);
        return this;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public UpdateSecurityProfileRequest withInstanceId(String instanceId) {
        this.setInstanceId(instanceId);
        return this;
    }

    public Map<String, String> getAllowedAccessControlTags() {
        return this.allowedAccessControlTags;
    }

    public void setAllowedAccessControlTags(Map<String, String> allowedAccessControlTags) {
        this.allowedAccessControlTags = allowedAccessControlTags;
    }

    public UpdateSecurityProfileRequest withAllowedAccessControlTags(Map<String, String> allowedAccessControlTags) {
        this.setAllowedAccessControlTags(allowedAccessControlTags);
        return this;
    }

    public UpdateSecurityProfileRequest addAllowedAccessControlTagsEntry(String key, String value) {
        if (null == this.allowedAccessControlTags) {
            this.allowedAccessControlTags = new HashMap<String, String>();
        }
        if (this.allowedAccessControlTags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.allowedAccessControlTags.put(key, value);
        return this;
    }

    public UpdateSecurityProfileRequest clearAllowedAccessControlTagsEntries() {
        this.allowedAccessControlTags = null;
        return this;
    }

    public List<String> getTagRestrictedResources() {
        return this.tagRestrictedResources;
    }

    public void setTagRestrictedResources(Collection<String> tagRestrictedResources) {
        if (tagRestrictedResources == null) {
            this.tagRestrictedResources = null;
            return;
        }
        this.tagRestrictedResources = new ArrayList<String>(tagRestrictedResources);
    }

    public UpdateSecurityProfileRequest withTagRestrictedResources(String ... tagRestrictedResources) {
        if (this.tagRestrictedResources == null) {
            this.setTagRestrictedResources(new ArrayList<String>(tagRestrictedResources.length));
        }
        for (String ele : tagRestrictedResources) {
            this.tagRestrictedResources.add(ele);
        }
        return this;
    }

    public UpdateSecurityProfileRequest withTagRestrictedResources(Collection<String> tagRestrictedResources) {
        this.setTagRestrictedResources(tagRestrictedResources);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getPermissions() != null) {
            sb.append("Permissions: ").append(this.getPermissions()).append(",");
        }
        if (this.getSecurityProfileId() != null) {
            sb.append("SecurityProfileId: ").append(this.getSecurityProfileId()).append(",");
        }
        if (this.getInstanceId() != null) {
            sb.append("InstanceId: ").append(this.getInstanceId()).append(",");
        }
        if (this.getAllowedAccessControlTags() != null) {
            sb.append("AllowedAccessControlTags: ").append(this.getAllowedAccessControlTags()).append(",");
        }
        if (this.getTagRestrictedResources() != null) {
            sb.append("TagRestrictedResources: ").append(this.getTagRestrictedResources());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSecurityProfileRequest)) {
            return false;
        }
        UpdateSecurityProfileRequest other = (UpdateSecurityProfileRequest)obj;
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getPermissions() == null ^ this.getPermissions() == null) {
            return false;
        }
        if (other.getPermissions() != null && !other.getPermissions().equals(this.getPermissions())) {
            return false;
        }
        if (other.getSecurityProfileId() == null ^ this.getSecurityProfileId() == null) {
            return false;
        }
        if (other.getSecurityProfileId() != null && !other.getSecurityProfileId().equals(this.getSecurityProfileId())) {
            return false;
        }
        if (other.getInstanceId() == null ^ this.getInstanceId() == null) {
            return false;
        }
        if (other.getInstanceId() != null && !other.getInstanceId().equals(this.getInstanceId())) {
            return false;
        }
        if (other.getAllowedAccessControlTags() == null ^ this.getAllowedAccessControlTags() == null) {
            return false;
        }
        if (other.getAllowedAccessControlTags() != null && !other.getAllowedAccessControlTags().equals(this.getAllowedAccessControlTags())) {
            return false;
        }
        if (other.getTagRestrictedResources() == null ^ this.getTagRestrictedResources() == null) {
            return false;
        }
        return other.getTagRestrictedResources() == null || other.getTagRestrictedResources().equals(this.getTagRestrictedResources());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getPermissions() == null ? 0 : this.getPermissions().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityProfileId() == null ? 0 : this.getSecurityProfileId().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceId() == null ? 0 : this.getInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getAllowedAccessControlTags() == null ? 0 : this.getAllowedAccessControlTags().hashCode());
        hashCode = 31 * hashCode + (this.getTagRestrictedResources() == null ? 0 : this.getTagRestrictedResources().hashCode());
        return hashCode;
    }

    public UpdateSecurityProfileRequest clone() {
        return (UpdateSecurityProfileRequest)super.clone();
    }
}

