/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connectwisdom.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.connectwisdom.model.ContentData;
import java.util.Date;
import java.util.Map;

@SdkInternalApi
public class ContentDataMarshaller {
    private static final MarshallingInfo<String> CONTENTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("contentArn").build();
    private static final MarshallingInfo<String> CONTENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("contentId").build();
    private static final MarshallingInfo<String> CONTENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("contentType").build();
    private static final MarshallingInfo<String> KNOWLEDGEBASEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("knowledgeBaseArn").build();
    private static final MarshallingInfo<String> KNOWLEDGEBASEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("knowledgeBaseId").build();
    private static final MarshallingInfo<String> LINKOUTURI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("linkOutUri").build();
    private static final MarshallingInfo<Map> METADATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("metadata").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> REVISIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("revisionId").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").build();
    private static final MarshallingInfo<String> TITLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("title").build();
    private static final MarshallingInfo<String> URL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("url").build();
    private static final MarshallingInfo<Date> URLEXPIRY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("urlExpiry").timestampFormat("unixTimestamp").build();
    private static final ContentDataMarshaller instance = new ContentDataMarshaller();

    public static ContentDataMarshaller getInstance() {
        return instance;
    }

    public void marshall(ContentData contentData, ProtocolMarshaller protocolMarshaller) {
        if (contentData == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)contentData.getContentArn(), CONTENTARN_BINDING);
            protocolMarshaller.marshall((Object)contentData.getContentId(), CONTENTID_BINDING);
            protocolMarshaller.marshall((Object)contentData.getContentType(), CONTENTTYPE_BINDING);
            protocolMarshaller.marshall((Object)contentData.getKnowledgeBaseArn(), KNOWLEDGEBASEARN_BINDING);
            protocolMarshaller.marshall((Object)contentData.getKnowledgeBaseId(), KNOWLEDGEBASEID_BINDING);
            protocolMarshaller.marshall((Object)contentData.getLinkOutUri(), LINKOUTURI_BINDING);
            protocolMarshaller.marshall(contentData.getMetadata(), METADATA_BINDING);
            protocolMarshaller.marshall((Object)contentData.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)contentData.getRevisionId(), REVISIONID_BINDING);
            protocolMarshaller.marshall((Object)contentData.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall(contentData.getTags(), TAGS_BINDING);
            protocolMarshaller.marshall((Object)contentData.getTitle(), TITLE_BINDING);
            protocolMarshaller.marshall((Object)contentData.getUrl(), URL_BINDING);
            protocolMarshaller.marshall((Object)contentData.getUrlExpiry(), URLEXPIRY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

