/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dax.model.transform;

import com.amazonaws.services.dax.model.Node;
import com.amazonaws.services.dax.model.transform.EndpointJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;
import java.util.Date;

public class NodeJsonUnmarshaller
implements Unmarshaller<Node, JsonUnmarshallerContext> {
    private static NodeJsonUnmarshaller instance;

    public Node unmarshall(JsonUnmarshallerContext context) throws Exception {
        Node node = new Node();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("NodeId", targetDepth)) {
                    context.nextToken();
                    node.setNodeId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Endpoint", targetDepth)) {
                    context.nextToken();
                    node.setEndpoint(EndpointJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("NodeCreateTime", targetDepth)) {
                    context.nextToken();
                    node.setNodeCreateTime((Date)context.getUnmarshaller(Date.class).unmarshall((Object)context));
                }
                if (context.testExpression("AvailabilityZone", targetDepth)) {
                    context.nextToken();
                    node.setAvailabilityZone((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("NodeStatus", targetDepth)) {
                    context.nextToken();
                    node.setNodeStatus((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ParameterGroupStatus", targetDepth)) {
                    context.nextToken();
                    node.setParameterGroupStatus((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return node;
    }

    public static NodeJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new NodeJsonUnmarshaller();
        }
        return instance;
    }
}

