/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.directory.model.ConnectDirectoryRequest;
import com.amazonaws.services.directory.model.DirectoryConnectSettings;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class ConnectDirectoryRequestMarshaller
implements Marshaller<Request<ConnectDirectoryRequest>, ConnectDirectoryRequest> {
    public Request<ConnectDirectoryRequest> marshall(ConnectDirectoryRequest connectDirectoryRequest) {
        if (connectDirectoryRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)connectDirectoryRequest, "AWSDirectoryService");
        String target = "DirectoryService_20150416.ConnectDirectory";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            DirectoryConnectSettings connectSettings;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (connectDirectoryRequest.getName() != null) {
                jsonWriter.key("Name").value((Object)connectDirectoryRequest.getName());
            }
            if (connectDirectoryRequest.getShortName() != null) {
                jsonWriter.key("ShortName").value((Object)connectDirectoryRequest.getShortName());
            }
            if (connectDirectoryRequest.getPassword() != null) {
                jsonWriter.key("Password").value((Object)connectDirectoryRequest.getPassword());
            }
            if (connectDirectoryRequest.getDescription() != null) {
                jsonWriter.key("Description").value((Object)connectDirectoryRequest.getDescription());
            }
            if (connectDirectoryRequest.getSize() != null) {
                jsonWriter.key("Size").value((Object)connectDirectoryRequest.getSize());
            }
            if ((connectSettings = connectDirectoryRequest.getConnectSettings()) != null) {
                ListWithAutoConstructFlag customerDnsIpsList;
                ListWithAutoConstructFlag subnetIdsList;
                jsonWriter.key("ConnectSettings");
                jsonWriter.object();
                if (connectSettings.getVpcId() != null) {
                    jsonWriter.key("VpcId").value((Object)connectSettings.getVpcId());
                }
                if (!((subnetIdsList = (ListWithAutoConstructFlag)connectSettings.getSubnetIds()) == null || subnetIdsList.isAutoConstruct() && subnetIdsList.isEmpty())) {
                    jsonWriter.key("SubnetIds");
                    jsonWriter.array();
                    for (String subnetIdsListValue : subnetIdsList) {
                        if (subnetIdsListValue == null) continue;
                        jsonWriter.value((Object)subnetIdsListValue);
                    }
                    jsonWriter.endArray();
                }
                if (!((customerDnsIpsList = (ListWithAutoConstructFlag)connectSettings.getCustomerDnsIps()) == null || customerDnsIpsList.isAutoConstruct() && customerDnsIpsList.isEmpty())) {
                    jsonWriter.key("CustomerDnsIps");
                    jsonWriter.array();
                    for (String customerDnsIpsListValue : customerDnsIpsList) {
                        if (customerDnsIpsListValue == null) continue;
                        jsonWriter.value((Object)customerDnsIpsListValue);
                    }
                    jsonWriter.endArray();
                }
                if (connectSettings.getCustomerUserName() != null) {
                    jsonWriter.key("CustomerUserName").value((Object)connectSettings.getCustomerUserName());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

