/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.directory.model.ConnectDirectoryRequest;
import com.amazonaws.services.directory.model.transform.DirectoryConnectSettingsJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class ConnectDirectoryRequestMarshaller
implements Marshaller<Request<ConnectDirectoryRequest>, ConnectDirectoryRequest> {
    public Request<ConnectDirectoryRequest> marshall(ConnectDirectoryRequest connectDirectoryRequest) {
        if (connectDirectoryRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)connectDirectoryRequest, "AWSDirectoryService");
        request.addHeader("X-Amz-Target", "DirectoryService_20150416.ConnectDirectory");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (connectDirectoryRequest.getName() != null) {
                jsonWriter.key("Name").value((Object)connectDirectoryRequest.getName());
            }
            if (connectDirectoryRequest.getShortName() != null) {
                jsonWriter.key("ShortName").value((Object)connectDirectoryRequest.getShortName());
            }
            if (connectDirectoryRequest.getPassword() != null) {
                jsonWriter.key("Password").value((Object)connectDirectoryRequest.getPassword());
            }
            if (connectDirectoryRequest.getDescription() != null) {
                jsonWriter.key("Description").value((Object)connectDirectoryRequest.getDescription());
            }
            if (connectDirectoryRequest.getSize() != null) {
                jsonWriter.key("Size").value((Object)connectDirectoryRequest.getSize());
            }
            if (connectDirectoryRequest.getConnectSettings() != null) {
                jsonWriter.key("ConnectSettings");
                DirectoryConnectSettingsJsonMarshaller.getInstance().marshall(connectDirectoryRequest.getConnectSettings(), jsonWriter);
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

