/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.directory.model.Trust;
import java.util.Date;

@SdkInternalApi
public class TrustMarshaller {
    private static final MarshallingInfo<String> DIRECTORYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DirectoryId").build();
    private static final MarshallingInfo<String> TRUSTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrustId").build();
    private static final MarshallingInfo<String> REMOTEDOMAINNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RemoteDomainName").build();
    private static final MarshallingInfo<String> TRUSTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrustType").build();
    private static final MarshallingInfo<String> TRUSTDIRECTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrustDirection").build();
    private static final MarshallingInfo<String> TRUSTSTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrustState").build();
    private static final MarshallingInfo<Date> CREATEDDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedDateTime").build();
    private static final MarshallingInfo<Date> LASTUPDATEDDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdatedDateTime").build();
    private static final MarshallingInfo<Date> STATELASTUPDATEDDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StateLastUpdatedDateTime").build();
    private static final MarshallingInfo<String> TRUSTSTATEREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrustStateReason").build();
    private static final MarshallingInfo<String> SELECTIVEAUTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SelectiveAuth").build();
    private static final TrustMarshaller instance = new TrustMarshaller();

    public static TrustMarshaller getInstance() {
        return instance;
    }

    public void marshall(Trust trust, ProtocolMarshaller protocolMarshaller) {
        if (trust == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)trust.getDirectoryId(), DIRECTORYID_BINDING);
            protocolMarshaller.marshall((Object)trust.getTrustId(), TRUSTID_BINDING);
            protocolMarshaller.marshall((Object)trust.getRemoteDomainName(), REMOTEDOMAINNAME_BINDING);
            protocolMarshaller.marshall((Object)trust.getTrustType(), TRUSTTYPE_BINDING);
            protocolMarshaller.marshall((Object)trust.getTrustDirection(), TRUSTDIRECTION_BINDING);
            protocolMarshaller.marshall((Object)trust.getTrustState(), TRUSTSTATE_BINDING);
            protocolMarshaller.marshall((Object)trust.getCreatedDateTime(), CREATEDDATETIME_BINDING);
            protocolMarshaller.marshall((Object)trust.getLastUpdatedDateTime(), LASTUPDATEDDATETIME_BINDING);
            protocolMarshaller.marshall((Object)trust.getStateLastUpdatedDateTime(), STATELASTUPDATEDDATETIME_BINDING);
            protocolMarshaller.marshall((Object)trust.getTrustStateReason(), TRUSTSTATEREASON_BINDING);
            protocolMarshaller.marshall((Object)trust.getSelectiveAuth(), SELECTIVEAUTH_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

