/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.directory.model.DirectoryConnectSettingsDescription;
import com.amazonaws.services.directory.model.DirectoryEdition;
import com.amazonaws.services.directory.model.DirectorySize;
import com.amazonaws.services.directory.model.DirectoryStage;
import com.amazonaws.services.directory.model.DirectoryType;
import com.amazonaws.services.directory.model.DirectoryVpcSettingsDescription;
import com.amazonaws.services.directory.model.OwnerDirectoryDescription;
import com.amazonaws.services.directory.model.RadiusSettings;
import com.amazonaws.services.directory.model.RadiusStatus;
import com.amazonaws.services.directory.model.RegionsInfo;
import com.amazonaws.services.directory.model.ShareMethod;
import com.amazonaws.services.directory.model.ShareStatus;
import com.amazonaws.services.directory.model.transform.DirectoryDescriptionMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class DirectoryDescription
implements Serializable,
Cloneable,
StructuredPojo {
    private String directoryId;
    private String name;
    private String shortName;
    private String size;
    private String edition;
    private String alias;
    private String accessUrl;
    private String description;
    private SdkInternalList<String> dnsIpAddrs;
    private String stage;
    private String shareStatus;
    private String shareMethod;
    private String shareNotes;
    private Date launchTime;
    private Date stageLastUpdatedDateTime;
    private String type;
    private DirectoryVpcSettingsDescription vpcSettings;
    private DirectoryConnectSettingsDescription connectSettings;
    private RadiusSettings radiusSettings;
    private String radiusStatus;
    private String stageReason;
    private Boolean ssoEnabled;
    private Integer desiredNumberOfDomainControllers;
    private OwnerDirectoryDescription ownerDirectoryDescription;
    private RegionsInfo regionsInfo;

    public void setDirectoryId(String directoryId) {
        this.directoryId = directoryId;
    }

    public String getDirectoryId() {
        return this.directoryId;
    }

    public DirectoryDescription withDirectoryId(String directoryId) {
        this.setDirectoryId(directoryId);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public DirectoryDescription withName(String name) {
        this.setName(name);
        return this;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public DirectoryDescription withShortName(String shortName) {
        this.setShortName(shortName);
        return this;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public String getSize() {
        return this.size;
    }

    public DirectoryDescription withSize(String size) {
        this.setSize(size);
        return this;
    }

    public void setSize(DirectorySize size) {
        this.withSize(size);
    }

    public DirectoryDescription withSize(DirectorySize size) {
        this.size = size.toString();
        return this;
    }

    public void setEdition(String edition) {
        this.edition = edition;
    }

    public String getEdition() {
        return this.edition;
    }

    public DirectoryDescription withEdition(String edition) {
        this.setEdition(edition);
        return this;
    }

    public void setEdition(DirectoryEdition edition) {
        this.withEdition(edition);
    }

    public DirectoryDescription withEdition(DirectoryEdition edition) {
        this.edition = edition.toString();
        return this;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getAlias() {
        return this.alias;
    }

    public DirectoryDescription withAlias(String alias) {
        this.setAlias(alias);
        return this;
    }

    public void setAccessUrl(String accessUrl) {
        this.accessUrl = accessUrl;
    }

    public String getAccessUrl() {
        return this.accessUrl;
    }

    public DirectoryDescription withAccessUrl(String accessUrl) {
        this.setAccessUrl(accessUrl);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public DirectoryDescription withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<String> getDnsIpAddrs() {
        if (this.dnsIpAddrs == null) {
            this.dnsIpAddrs = new SdkInternalList();
        }
        return this.dnsIpAddrs;
    }

    public void setDnsIpAddrs(Collection<String> dnsIpAddrs) {
        if (dnsIpAddrs == null) {
            this.dnsIpAddrs = null;
            return;
        }
        this.dnsIpAddrs = new SdkInternalList(dnsIpAddrs);
    }

    public DirectoryDescription withDnsIpAddrs(String ... dnsIpAddrs) {
        if (this.dnsIpAddrs == null) {
            this.setDnsIpAddrs((Collection<String>)new SdkInternalList(dnsIpAddrs.length));
        }
        for (String ele : dnsIpAddrs) {
            this.dnsIpAddrs.add((Object)ele);
        }
        return this;
    }

    public DirectoryDescription withDnsIpAddrs(Collection<String> dnsIpAddrs) {
        this.setDnsIpAddrs(dnsIpAddrs);
        return this;
    }

    public void setStage(String stage) {
        this.stage = stage;
    }

    public String getStage() {
        return this.stage;
    }

    public DirectoryDescription withStage(String stage) {
        this.setStage(stage);
        return this;
    }

    public void setStage(DirectoryStage stage) {
        this.withStage(stage);
    }

    public DirectoryDescription withStage(DirectoryStage stage) {
        this.stage = stage.toString();
        return this;
    }

    public void setShareStatus(String shareStatus) {
        this.shareStatus = shareStatus;
    }

    public String getShareStatus() {
        return this.shareStatus;
    }

    public DirectoryDescription withShareStatus(String shareStatus) {
        this.setShareStatus(shareStatus);
        return this;
    }

    public void setShareStatus(ShareStatus shareStatus) {
        this.withShareStatus(shareStatus);
    }

    public DirectoryDescription withShareStatus(ShareStatus shareStatus) {
        this.shareStatus = shareStatus.toString();
        return this;
    }

    public void setShareMethod(String shareMethod) {
        this.shareMethod = shareMethod;
    }

    public String getShareMethod() {
        return this.shareMethod;
    }

    public DirectoryDescription withShareMethod(String shareMethod) {
        this.setShareMethod(shareMethod);
        return this;
    }

    public void setShareMethod(ShareMethod shareMethod) {
        this.withShareMethod(shareMethod);
    }

    public DirectoryDescription withShareMethod(ShareMethod shareMethod) {
        this.shareMethod = shareMethod.toString();
        return this;
    }

    public void setShareNotes(String shareNotes) {
        this.shareNotes = shareNotes;
    }

    public String getShareNotes() {
        return this.shareNotes;
    }

    public DirectoryDescription withShareNotes(String shareNotes) {
        this.setShareNotes(shareNotes);
        return this;
    }

    public void setLaunchTime(Date launchTime) {
        this.launchTime = launchTime;
    }

    public Date getLaunchTime() {
        return this.launchTime;
    }

    public DirectoryDescription withLaunchTime(Date launchTime) {
        this.setLaunchTime(launchTime);
        return this;
    }

    public void setStageLastUpdatedDateTime(Date stageLastUpdatedDateTime) {
        this.stageLastUpdatedDateTime = stageLastUpdatedDateTime;
    }

    public Date getStageLastUpdatedDateTime() {
        return this.stageLastUpdatedDateTime;
    }

    public DirectoryDescription withStageLastUpdatedDateTime(Date stageLastUpdatedDateTime) {
        this.setStageLastUpdatedDateTime(stageLastUpdatedDateTime);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public DirectoryDescription withType(String type) {
        this.setType(type);
        return this;
    }

    public void setType(DirectoryType type) {
        this.withType(type);
    }

    public DirectoryDescription withType(DirectoryType type) {
        this.type = type.toString();
        return this;
    }

    public void setVpcSettings(DirectoryVpcSettingsDescription vpcSettings) {
        this.vpcSettings = vpcSettings;
    }

    public DirectoryVpcSettingsDescription getVpcSettings() {
        return this.vpcSettings;
    }

    public DirectoryDescription withVpcSettings(DirectoryVpcSettingsDescription vpcSettings) {
        this.setVpcSettings(vpcSettings);
        return this;
    }

    public void setConnectSettings(DirectoryConnectSettingsDescription connectSettings) {
        this.connectSettings = connectSettings;
    }

    public DirectoryConnectSettingsDescription getConnectSettings() {
        return this.connectSettings;
    }

    public DirectoryDescription withConnectSettings(DirectoryConnectSettingsDescription connectSettings) {
        this.setConnectSettings(connectSettings);
        return this;
    }

    public void setRadiusSettings(RadiusSettings radiusSettings) {
        this.radiusSettings = radiusSettings;
    }

    public RadiusSettings getRadiusSettings() {
        return this.radiusSettings;
    }

    public DirectoryDescription withRadiusSettings(RadiusSettings radiusSettings) {
        this.setRadiusSettings(radiusSettings);
        return this;
    }

    public void setRadiusStatus(String radiusStatus) {
        this.radiusStatus = radiusStatus;
    }

    public String getRadiusStatus() {
        return this.radiusStatus;
    }

    public DirectoryDescription withRadiusStatus(String radiusStatus) {
        this.setRadiusStatus(radiusStatus);
        return this;
    }

    public void setRadiusStatus(RadiusStatus radiusStatus) {
        this.withRadiusStatus(radiusStatus);
    }

    public DirectoryDescription withRadiusStatus(RadiusStatus radiusStatus) {
        this.radiusStatus = radiusStatus.toString();
        return this;
    }

    public void setStageReason(String stageReason) {
        this.stageReason = stageReason;
    }

    public String getStageReason() {
        return this.stageReason;
    }

    public DirectoryDescription withStageReason(String stageReason) {
        this.setStageReason(stageReason);
        return this;
    }

    public void setSsoEnabled(Boolean ssoEnabled) {
        this.ssoEnabled = ssoEnabled;
    }

    public Boolean getSsoEnabled() {
        return this.ssoEnabled;
    }

    public DirectoryDescription withSsoEnabled(Boolean ssoEnabled) {
        this.setSsoEnabled(ssoEnabled);
        return this;
    }

    public Boolean isSsoEnabled() {
        return this.ssoEnabled;
    }

    public void setDesiredNumberOfDomainControllers(Integer desiredNumberOfDomainControllers) {
        this.desiredNumberOfDomainControllers = desiredNumberOfDomainControllers;
    }

    public Integer getDesiredNumberOfDomainControllers() {
        return this.desiredNumberOfDomainControllers;
    }

    public DirectoryDescription withDesiredNumberOfDomainControllers(Integer desiredNumberOfDomainControllers) {
        this.setDesiredNumberOfDomainControllers(desiredNumberOfDomainControllers);
        return this;
    }

    public void setOwnerDirectoryDescription(OwnerDirectoryDescription ownerDirectoryDescription) {
        this.ownerDirectoryDescription = ownerDirectoryDescription;
    }

    public OwnerDirectoryDescription getOwnerDirectoryDescription() {
        return this.ownerDirectoryDescription;
    }

    public DirectoryDescription withOwnerDirectoryDescription(OwnerDirectoryDescription ownerDirectoryDescription) {
        this.setOwnerDirectoryDescription(ownerDirectoryDescription);
        return this;
    }

    public void setRegionsInfo(RegionsInfo regionsInfo) {
        this.regionsInfo = regionsInfo;
    }

    public RegionsInfo getRegionsInfo() {
        return this.regionsInfo;
    }

    public DirectoryDescription withRegionsInfo(RegionsInfo regionsInfo) {
        this.setRegionsInfo(regionsInfo);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDirectoryId() != null) {
            sb.append("DirectoryId: ").append(this.getDirectoryId()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getShortName() != null) {
            sb.append("ShortName: ").append(this.getShortName()).append(",");
        }
        if (this.getSize() != null) {
            sb.append("Size: ").append(this.getSize()).append(",");
        }
        if (this.getEdition() != null) {
            sb.append("Edition: ").append(this.getEdition()).append(",");
        }
        if (this.getAlias() != null) {
            sb.append("Alias: ").append(this.getAlias()).append(",");
        }
        if (this.getAccessUrl() != null) {
            sb.append("AccessUrl: ").append(this.getAccessUrl()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getDnsIpAddrs() != null) {
            sb.append("DnsIpAddrs: ").append(this.getDnsIpAddrs()).append(",");
        }
        if (this.getStage() != null) {
            sb.append("Stage: ").append(this.getStage()).append(",");
        }
        if (this.getShareStatus() != null) {
            sb.append("ShareStatus: ").append(this.getShareStatus()).append(",");
        }
        if (this.getShareMethod() != null) {
            sb.append("ShareMethod: ").append(this.getShareMethod()).append(",");
        }
        if (this.getShareNotes() != null) {
            sb.append("ShareNotes: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getLaunchTime() != null) {
            sb.append("LaunchTime: ").append(this.getLaunchTime()).append(",");
        }
        if (this.getStageLastUpdatedDateTime() != null) {
            sb.append("StageLastUpdatedDateTime: ").append(this.getStageLastUpdatedDateTime()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getVpcSettings() != null) {
            sb.append("VpcSettings: ").append(this.getVpcSettings()).append(",");
        }
        if (this.getConnectSettings() != null) {
            sb.append("ConnectSettings: ").append(this.getConnectSettings()).append(",");
        }
        if (this.getRadiusSettings() != null) {
            sb.append("RadiusSettings: ").append(this.getRadiusSettings()).append(",");
        }
        if (this.getRadiusStatus() != null) {
            sb.append("RadiusStatus: ").append(this.getRadiusStatus()).append(",");
        }
        if (this.getStageReason() != null) {
            sb.append("StageReason: ").append(this.getStageReason()).append(",");
        }
        if (this.getSsoEnabled() != null) {
            sb.append("SsoEnabled: ").append(this.getSsoEnabled()).append(",");
        }
        if (this.getDesiredNumberOfDomainControllers() != null) {
            sb.append("DesiredNumberOfDomainControllers: ").append(this.getDesiredNumberOfDomainControllers()).append(",");
        }
        if (this.getOwnerDirectoryDescription() != null) {
            sb.append("OwnerDirectoryDescription: ").append(this.getOwnerDirectoryDescription()).append(",");
        }
        if (this.getRegionsInfo() != null) {
            sb.append("RegionsInfo: ").append(this.getRegionsInfo());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DirectoryDescription)) {
            return false;
        }
        DirectoryDescription other = (DirectoryDescription)obj;
        if (other.getDirectoryId() == null ^ this.getDirectoryId() == null) {
            return false;
        }
        if (other.getDirectoryId() != null && !other.getDirectoryId().equals(this.getDirectoryId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getShortName() == null ^ this.getShortName() == null) {
            return false;
        }
        if (other.getShortName() != null && !other.getShortName().equals(this.getShortName())) {
            return false;
        }
        if (other.getSize() == null ^ this.getSize() == null) {
            return false;
        }
        if (other.getSize() != null && !other.getSize().equals(this.getSize())) {
            return false;
        }
        if (other.getEdition() == null ^ this.getEdition() == null) {
            return false;
        }
        if (other.getEdition() != null && !other.getEdition().equals(this.getEdition())) {
            return false;
        }
        if (other.getAlias() == null ^ this.getAlias() == null) {
            return false;
        }
        if (other.getAlias() != null && !other.getAlias().equals(this.getAlias())) {
            return false;
        }
        if (other.getAccessUrl() == null ^ this.getAccessUrl() == null) {
            return false;
        }
        if (other.getAccessUrl() != null && !other.getAccessUrl().equals(this.getAccessUrl())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getDnsIpAddrs() == null ^ this.getDnsIpAddrs() == null) {
            return false;
        }
        if (other.getDnsIpAddrs() != null && !other.getDnsIpAddrs().equals(this.getDnsIpAddrs())) {
            return false;
        }
        if (other.getStage() == null ^ this.getStage() == null) {
            return false;
        }
        if (other.getStage() != null && !other.getStage().equals(this.getStage())) {
            return false;
        }
        if (other.getShareStatus() == null ^ this.getShareStatus() == null) {
            return false;
        }
        if (other.getShareStatus() != null && !other.getShareStatus().equals(this.getShareStatus())) {
            return false;
        }
        if (other.getShareMethod() == null ^ this.getShareMethod() == null) {
            return false;
        }
        if (other.getShareMethod() != null && !other.getShareMethod().equals(this.getShareMethod())) {
            return false;
        }
        if (other.getShareNotes() == null ^ this.getShareNotes() == null) {
            return false;
        }
        if (other.getShareNotes() != null && !other.getShareNotes().equals(this.getShareNotes())) {
            return false;
        }
        if (other.getLaunchTime() == null ^ this.getLaunchTime() == null) {
            return false;
        }
        if (other.getLaunchTime() != null && !other.getLaunchTime().equals(this.getLaunchTime())) {
            return false;
        }
        if (other.getStageLastUpdatedDateTime() == null ^ this.getStageLastUpdatedDateTime() == null) {
            return false;
        }
        if (other.getStageLastUpdatedDateTime() != null && !other.getStageLastUpdatedDateTime().equals(this.getStageLastUpdatedDateTime())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getVpcSettings() == null ^ this.getVpcSettings() == null) {
            return false;
        }
        if (other.getVpcSettings() != null && !other.getVpcSettings().equals(this.getVpcSettings())) {
            return false;
        }
        if (other.getConnectSettings() == null ^ this.getConnectSettings() == null) {
            return false;
        }
        if (other.getConnectSettings() != null && !other.getConnectSettings().equals(this.getConnectSettings())) {
            return false;
        }
        if (other.getRadiusSettings() == null ^ this.getRadiusSettings() == null) {
            return false;
        }
        if (other.getRadiusSettings() != null && !other.getRadiusSettings().equals(this.getRadiusSettings())) {
            return false;
        }
        if (other.getRadiusStatus() == null ^ this.getRadiusStatus() == null) {
            return false;
        }
        if (other.getRadiusStatus() != null && !other.getRadiusStatus().equals(this.getRadiusStatus())) {
            return false;
        }
        if (other.getStageReason() == null ^ this.getStageReason() == null) {
            return false;
        }
        if (other.getStageReason() != null && !other.getStageReason().equals(this.getStageReason())) {
            return false;
        }
        if (other.getSsoEnabled() == null ^ this.getSsoEnabled() == null) {
            return false;
        }
        if (other.getSsoEnabled() != null && !other.getSsoEnabled().equals(this.getSsoEnabled())) {
            return false;
        }
        if (other.getDesiredNumberOfDomainControllers() == null ^ this.getDesiredNumberOfDomainControllers() == null) {
            return false;
        }
        if (other.getDesiredNumberOfDomainControllers() != null && !other.getDesiredNumberOfDomainControllers().equals(this.getDesiredNumberOfDomainControllers())) {
            return false;
        }
        if (other.getOwnerDirectoryDescription() == null ^ this.getOwnerDirectoryDescription() == null) {
            return false;
        }
        if (other.getOwnerDirectoryDescription() != null && !other.getOwnerDirectoryDescription().equals(this.getOwnerDirectoryDescription())) {
            return false;
        }
        if (other.getRegionsInfo() == null ^ this.getRegionsInfo() == null) {
            return false;
        }
        return other.getRegionsInfo() == null || other.getRegionsInfo().equals(this.getRegionsInfo());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDirectoryId() == null ? 0 : this.getDirectoryId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getShortName() == null ? 0 : this.getShortName().hashCode());
        hashCode = 31 * hashCode + (this.getSize() == null ? 0 : this.getSize().hashCode());
        hashCode = 31 * hashCode + (this.getEdition() == null ? 0 : this.getEdition().hashCode());
        hashCode = 31 * hashCode + (this.getAlias() == null ? 0 : this.getAlias().hashCode());
        hashCode = 31 * hashCode + (this.getAccessUrl() == null ? 0 : this.getAccessUrl().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getDnsIpAddrs() == null ? 0 : this.getDnsIpAddrs().hashCode());
        hashCode = 31 * hashCode + (this.getStage() == null ? 0 : this.getStage().hashCode());
        hashCode = 31 * hashCode + (this.getShareStatus() == null ? 0 : this.getShareStatus().hashCode());
        hashCode = 31 * hashCode + (this.getShareMethod() == null ? 0 : this.getShareMethod().hashCode());
        hashCode = 31 * hashCode + (this.getShareNotes() == null ? 0 : this.getShareNotes().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchTime() == null ? 0 : this.getLaunchTime().hashCode());
        hashCode = 31 * hashCode + (this.getStageLastUpdatedDateTime() == null ? 0 : this.getStageLastUpdatedDateTime().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getVpcSettings() == null ? 0 : this.getVpcSettings().hashCode());
        hashCode = 31 * hashCode + (this.getConnectSettings() == null ? 0 : this.getConnectSettings().hashCode());
        hashCode = 31 * hashCode + (this.getRadiusSettings() == null ? 0 : this.getRadiusSettings().hashCode());
        hashCode = 31 * hashCode + (this.getRadiusStatus() == null ? 0 : this.getRadiusStatus().hashCode());
        hashCode = 31 * hashCode + (this.getStageReason() == null ? 0 : this.getStageReason().hashCode());
        hashCode = 31 * hashCode + (this.getSsoEnabled() == null ? 0 : this.getSsoEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getDesiredNumberOfDomainControllers() == null ? 0 : this.getDesiredNumberOfDomainControllers().hashCode());
        hashCode = 31 * hashCode + (this.getOwnerDirectoryDescription() == null ? 0 : this.getOwnerDirectoryDescription().hashCode());
        hashCode = 31 * hashCode + (this.getRegionsInfo() == null ? 0 : this.getRegionsInfo().hashCode());
        return hashCode;
    }

    public DirectoryDescription clone() {
        try {
            return (DirectoryDescription)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DirectoryDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

