/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.drs.model.transform;

import java.util.List;
import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.drs.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * DataReplicationInfoMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class DataReplicationInfoMarshaller {

    private static final MarshallingInfo<StructuredPojo> DATAREPLICATIONERROR_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dataReplicationError").build();
    private static final MarshallingInfo<StructuredPojo> DATAREPLICATIONINITIATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dataReplicationInitiation").build();
    private static final MarshallingInfo<String> DATAREPLICATIONSTATE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dataReplicationState").build();
    private static final MarshallingInfo<String> ETADATETIME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("etaDateTime").build();
    private static final MarshallingInfo<String> LAGDURATION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lagDuration").build();
    private static final MarshallingInfo<List> REPLICATEDDISKS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("replicatedDisks").build();
    private static final MarshallingInfo<String> STAGINGAVAILABILITYZONE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stagingAvailabilityZone").build();
    private static final MarshallingInfo<String> STAGINGOUTPOSTARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stagingOutpostArn").build();

    private static final DataReplicationInfoMarshaller instance = new DataReplicationInfoMarshaller();

    public static DataReplicationInfoMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(DataReplicationInfo dataReplicationInfo, ProtocolMarshaller protocolMarshaller) {

        if (dataReplicationInfo == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(dataReplicationInfo.getDataReplicationError(), DATAREPLICATIONERROR_BINDING);
            protocolMarshaller.marshall(dataReplicationInfo.getDataReplicationInitiation(), DATAREPLICATIONINITIATION_BINDING);
            protocolMarshaller.marshall(dataReplicationInfo.getDataReplicationState(), DATAREPLICATIONSTATE_BINDING);
            protocolMarshaller.marshall(dataReplicationInfo.getEtaDateTime(), ETADATETIME_BINDING);
            protocolMarshaller.marshall(dataReplicationInfo.getLagDuration(), LAGDURATION_BINDING);
            protocolMarshaller.marshall(dataReplicationInfo.getReplicatedDisks(), REPLICATEDDISKS_BINDING);
            protocolMarshaller.marshall(dataReplicationInfo.getStagingAvailabilityZone(), STAGINGAVAILABILITYZONE_BINDING);
            protocolMarshaller.marshall(dataReplicationInfo.getStagingOutpostArn(), STAGINGOUTPOSTARN_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
