/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DiskImage;
import com.amazonaws.services.ec2.model.DiskImageDetail;
import com.amazonaws.services.ec2.model.ImportInstanceLaunchSpecification;
import com.amazonaws.services.ec2.model.ImportInstanceRequest;
import com.amazonaws.services.ec2.model.Placement;
import com.amazonaws.services.ec2.model.UserData;
import com.amazonaws.services.ec2.model.VolumeDetail;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ImportInstanceRequestMarshaller
implements Marshaller<Request<ImportInstanceRequest>, ImportInstanceRequest> {
    public Request<ImportInstanceRequest> marshall(ImportInstanceRequest importInstanceRequest) {
        SdkInternalList diskImagesList;
        ImportInstanceLaunchSpecification launchSpecification;
        if (importInstanceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)importInstanceRequest, "AmazonEC2");
        request.addParameter("Action", "ImportInstance");
        request.addParameter("Version", "2015-10-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (importInstanceRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)importInstanceRequest.getDescription()));
        }
        if ((launchSpecification = importInstanceRequest.getLaunchSpecification()) != null) {
            Placement placement;
            UserData userData;
            SdkInternalList groupIdsList;
            SdkInternalList groupNamesList;
            if (launchSpecification.getArchitecture() != null) {
                request.addParameter("LaunchSpecification.Architecture", StringUtils.fromString((String)launchSpecification.getArchitecture()));
            }
            if (!(groupNamesList = (SdkInternalList)launchSpecification.getGroupNames()).isEmpty() || !groupNamesList.isAutoConstruct()) {
                int groupNamesListIndex = 1;
                for (Object groupNamesListValue : groupNamesList) {
                    if (groupNamesListValue != null) {
                        request.addParameter("LaunchSpecification.GroupName." + groupNamesListIndex, StringUtils.fromString((String)groupNamesListValue));
                    }
                    ++groupNamesListIndex;
                }
            }
            if (!(groupIdsList = (SdkInternalList)launchSpecification.getGroupIds()).isEmpty() || !groupIdsList.isAutoConstruct()) {
                int groupIdsListIndex = 1;
                for (String groupIdsListValue : groupIdsList) {
                    if (groupIdsListValue != null) {
                        request.addParameter("LaunchSpecification.GroupId." + groupIdsListIndex, StringUtils.fromString((String)groupIdsListValue));
                    }
                    ++groupIdsListIndex;
                }
            }
            if (launchSpecification.getAdditionalInfo() != null) {
                request.addParameter("LaunchSpecification.AdditionalInfo", StringUtils.fromString((String)launchSpecification.getAdditionalInfo()));
            }
            if ((userData = launchSpecification.getUserData()) != null && userData.getData() != null) {
                request.addParameter("LaunchSpecification.UserData.Data", StringUtils.fromString((String)userData.getData()));
            }
            if (launchSpecification.getInstanceType() != null) {
                request.addParameter("LaunchSpecification.InstanceType", StringUtils.fromString((String)launchSpecification.getInstanceType()));
            }
            if ((placement = launchSpecification.getPlacement()) != null) {
                if (placement.getAvailabilityZone() != null) {
                    request.addParameter("LaunchSpecification.Placement.AvailabilityZone", StringUtils.fromString((String)placement.getAvailabilityZone()));
                }
                if (placement.getGroupName() != null) {
                    request.addParameter("LaunchSpecification.Placement.GroupName", StringUtils.fromString((String)placement.getGroupName()));
                }
                if (placement.getTenancy() != null) {
                    request.addParameter("LaunchSpecification.Placement.Tenancy", StringUtils.fromString((String)placement.getTenancy()));
                }
                if (placement.getHostId() != null) {
                    request.addParameter("LaunchSpecification.Placement.HostId", StringUtils.fromString((String)placement.getHostId()));
                }
                if (placement.getAffinity() != null) {
                    request.addParameter("LaunchSpecification.Placement.Affinity", StringUtils.fromString((String)placement.getAffinity()));
                }
            }
            if (launchSpecification.getMonitoring() != null) {
                request.addParameter("LaunchSpecification.Monitoring.Enabled", StringUtils.fromBoolean((Boolean)launchSpecification.getMonitoring()));
            }
            if (launchSpecification.getSubnetId() != null) {
                request.addParameter("LaunchSpecification.SubnetId", StringUtils.fromString((String)launchSpecification.getSubnetId()));
            }
            if (launchSpecification.getInstanceInitiatedShutdownBehavior() != null) {
                request.addParameter("LaunchSpecification.InstanceInitiatedShutdownBehavior", StringUtils.fromString((String)launchSpecification.getInstanceInitiatedShutdownBehavior()));
            }
            if (launchSpecification.getPrivateIpAddress() != null) {
                request.addParameter("LaunchSpecification.PrivateIpAddress", StringUtils.fromString((String)launchSpecification.getPrivateIpAddress()));
            }
        }
        if (!(diskImagesList = (SdkInternalList)importInstanceRequest.getDiskImages()).isEmpty() || !diskImagesList.isAutoConstruct()) {
            int diskImagesListIndex = 1;
            for (DiskImage diskImagesListValue : diskImagesList) {
                VolumeDetail volume;
                DiskImageDetail image = diskImagesListValue.getImage();
                if (image != null) {
                    if (image.getFormat() != null) {
                        request.addParameter("DiskImage." + diskImagesListIndex + ".Image.Format", StringUtils.fromString((String)image.getFormat()));
                    }
                    if (image.getBytes() != null) {
                        request.addParameter("DiskImage." + diskImagesListIndex + ".Image.Bytes", StringUtils.fromLong((Long)image.getBytes()));
                    }
                    if (image.getImportManifestUrl() != null) {
                        request.addParameter("DiskImage." + diskImagesListIndex + ".Image.ImportManifestUrl", StringUtils.fromString((String)image.getImportManifestUrl()));
                    }
                }
                if (diskImagesListValue.getDescription() != null) {
                    request.addParameter("DiskImage." + diskImagesListIndex + ".Description", StringUtils.fromString((String)diskImagesListValue.getDescription()));
                }
                if ((volume = diskImagesListValue.getVolume()) != null && volume.getSize() != null) {
                    request.addParameter("DiskImage." + diskImagesListIndex + ".Volume.Size", StringUtils.fromLong((Long)volume.getSize()));
                }
                ++diskImagesListIndex;
            }
        }
        if (importInstanceRequest.getPlatform() != null) {
            request.addParameter("Platform", StringUtils.fromString((String)importInstanceRequest.getPlatform()));
        }
        return request;
    }
}

