/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.DiskImageDetail;
import com.amazonaws.services.ec2.model.ImportVolumeRequest;
import com.amazonaws.services.ec2.model.VolumeDetail;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ImportVolumeRequestMarshaller
implements Marshaller<Request<ImportVolumeRequest>, ImportVolumeRequest> {
    public Request<ImportVolumeRequest> marshall(ImportVolumeRequest importVolumeRequest) {
        VolumeDetail volume;
        DiskImageDetail image;
        if (importVolumeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)importVolumeRequest, "AmazonEC2");
        request.addParameter("Action", "ImportVolume");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (importVolumeRequest.getAvailabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString((String)importVolumeRequest.getAvailabilityZone()));
        }
        if (importVolumeRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)importVolumeRequest.getDescription()));
        }
        if ((image = importVolumeRequest.getImage()) != null) {
            if (image.getBytes() != null) {
                request.addParameter("Image.Bytes", StringUtils.fromLong((Long)image.getBytes()));
            }
            if (image.getFormat() != null) {
                request.addParameter("Image.Format", StringUtils.fromString((String)image.getFormat()));
            }
            if (image.getImportManifestUrl() != null) {
                request.addParameter("Image.ImportManifestUrl", StringUtils.fromString((String)image.getImportManifestUrl()));
            }
        }
        if ((volume = importVolumeRequest.getVolume()) != null && volume.getSize() != null) {
            request.addParameter("Volume.Size", StringUtils.fromLong((Long)volume.getSize()));
        }
        return request;
    }
}

