/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.LaunchPermission;
import com.amazonaws.services.ec2.model.LaunchPermissionModifications;
import com.amazonaws.services.ec2.model.ModifyImageAttributeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyImageAttributeRequestMarshaller
implements Marshaller<Request<ModifyImageAttributeRequest>, ModifyImageAttributeRequest> {
    public Request<ModifyImageAttributeRequest> marshall(ModifyImageAttributeRequest modifyImageAttributeRequest) {
        SdkInternalList modifyImageAttributeRequestUserIdsList;
        SdkInternalList modifyImageAttributeRequestUserGroupsList;
        SdkInternalList modifyImageAttributeRequestProductCodesList;
        LaunchPermissionModifications launchPermission;
        if (modifyImageAttributeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyImageAttributeRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyImageAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyImageAttributeRequest.getAttribute() != null) {
            request.addParameter("Attribute", StringUtils.fromString((String)modifyImageAttributeRequest.getAttribute()));
        }
        if (modifyImageAttributeRequest.getDescription() != null) {
            request.addParameter("Description.Value", StringUtils.fromString((String)modifyImageAttributeRequest.getDescription()));
        }
        if (modifyImageAttributeRequest.getImageId() != null) {
            request.addParameter("ImageId", StringUtils.fromString((String)modifyImageAttributeRequest.getImageId()));
        }
        if ((launchPermission = modifyImageAttributeRequest.getLaunchPermission()) != null) {
            SdkInternalList launchPermissionModificationsRemoveList;
            SdkInternalList launchPermissionModificationsAddList = (SdkInternalList)launchPermission.getAdd();
            if (!launchPermissionModificationsAddList.isEmpty() || !launchPermissionModificationsAddList.isAutoConstruct()) {
                int addListIndex = 1;
                for (Object launchPermissionModificationsAddListValue : launchPermissionModificationsAddList) {
                    if (((LaunchPermission)launchPermissionModificationsAddListValue).getGroup() != null) {
                        request.addParameter("LaunchPermission.Add." + addListIndex + ".Group", StringUtils.fromString((String)((LaunchPermission)launchPermissionModificationsAddListValue).getGroup()));
                    }
                    if (((LaunchPermission)launchPermissionModificationsAddListValue).getUserId() != null) {
                        request.addParameter("LaunchPermission.Add." + addListIndex + ".UserId", StringUtils.fromString((String)((LaunchPermission)launchPermissionModificationsAddListValue).getUserId()));
                    }
                    ++addListIndex;
                }
            }
            if (!(launchPermissionModificationsRemoveList = (SdkInternalList)launchPermission.getRemove()).isEmpty() || !launchPermissionModificationsRemoveList.isAutoConstruct()) {
                int removeListIndex = 1;
                for (LaunchPermission launchPermissionModificationsRemoveListValue : launchPermissionModificationsRemoveList) {
                    if (launchPermissionModificationsRemoveListValue.getGroup() != null) {
                        request.addParameter("LaunchPermission.Remove." + removeListIndex + ".Group", StringUtils.fromString((String)launchPermissionModificationsRemoveListValue.getGroup()));
                    }
                    if (launchPermissionModificationsRemoveListValue.getUserId() != null) {
                        request.addParameter("LaunchPermission.Remove." + removeListIndex + ".UserId", StringUtils.fromString((String)launchPermissionModificationsRemoveListValue.getUserId()));
                    }
                    ++removeListIndex;
                }
            }
        }
        if (modifyImageAttributeRequest.getOperationType() != null) {
            request.addParameter("OperationType", StringUtils.fromString((String)modifyImageAttributeRequest.getOperationType()));
        }
        if (!(modifyImageAttributeRequestProductCodesList = (SdkInternalList)modifyImageAttributeRequest.getProductCodes()).isEmpty() || !modifyImageAttributeRequestProductCodesList.isAutoConstruct()) {
            int productCodesListIndex = 1;
            for (Object modifyImageAttributeRequestProductCodesListValue : modifyImageAttributeRequestProductCodesList) {
                if (modifyImageAttributeRequestProductCodesListValue != null) {
                    request.addParameter("ProductCode." + productCodesListIndex, StringUtils.fromString((String)modifyImageAttributeRequestProductCodesListValue));
                }
                ++productCodesListIndex;
            }
        }
        if (!(modifyImageAttributeRequestUserGroupsList = (SdkInternalList)modifyImageAttributeRequest.getUserGroups()).isEmpty() || !modifyImageAttributeRequestUserGroupsList.isAutoConstruct()) {
            int userGroupsListIndex = 1;
            for (String modifyImageAttributeRequestUserGroupsListValue : modifyImageAttributeRequestUserGroupsList) {
                if (modifyImageAttributeRequestUserGroupsListValue != null) {
                    request.addParameter("UserGroup." + userGroupsListIndex, StringUtils.fromString((String)modifyImageAttributeRequestUserGroupsListValue));
                }
                ++userGroupsListIndex;
            }
        }
        if (!(modifyImageAttributeRequestUserIdsList = (SdkInternalList)modifyImageAttributeRequest.getUserIds()).isEmpty() || !modifyImageAttributeRequestUserIdsList.isAutoConstruct()) {
            int userIdsListIndex = 1;
            for (String modifyImageAttributeRequestUserIdsListValue : modifyImageAttributeRequestUserIdsList) {
                if (modifyImageAttributeRequestUserIdsListValue != null) {
                    request.addParameter("UserId." + userIdsListIndex, StringUtils.fromString((String)modifyImageAttributeRequestUserIdsListValue));
                }
                ++userIdsListIndex;
            }
        }
        if (modifyImageAttributeRequest.getValue() != null) {
            request.addParameter("Value", StringUtils.fromString((String)modifyImageAttributeRequest.getValue()));
        }
        return request;
    }
}

