/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DhcpConfiguration;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.transform.CreateDhcpOptionsRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateDhcpOptionsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<CreateDhcpOptionsRequest> {
    private SdkInternalList<DhcpConfiguration> dhcpConfigurations;

    public CreateDhcpOptionsRequest() {
    }

    public CreateDhcpOptionsRequest(List<DhcpConfiguration> dhcpConfigurations) {
        this.setDhcpConfigurations(dhcpConfigurations);
    }

    public List<DhcpConfiguration> getDhcpConfigurations() {
        if (this.dhcpConfigurations == null) {
            this.dhcpConfigurations = new SdkInternalList();
        }
        return this.dhcpConfigurations;
    }

    public void setDhcpConfigurations(Collection<DhcpConfiguration> dhcpConfigurations) {
        if (dhcpConfigurations == null) {
            this.dhcpConfigurations = null;
            return;
        }
        this.dhcpConfigurations = new SdkInternalList(dhcpConfigurations);
    }

    public CreateDhcpOptionsRequest withDhcpConfigurations(DhcpConfiguration ... dhcpConfigurations) {
        if (this.dhcpConfigurations == null) {
            this.setDhcpConfigurations((Collection<DhcpConfiguration>)new SdkInternalList(dhcpConfigurations.length));
        }
        for (DhcpConfiguration ele : dhcpConfigurations) {
            this.dhcpConfigurations.add((Object)ele);
        }
        return this;
    }

    public CreateDhcpOptionsRequest withDhcpConfigurations(Collection<DhcpConfiguration> dhcpConfigurations) {
        this.setDhcpConfigurations(dhcpConfigurations);
        return this;
    }

    @Override
    public Request<CreateDhcpOptionsRequest> getDryRunRequest() {
        Request<CreateDhcpOptionsRequest> request = new CreateDhcpOptionsRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDhcpConfigurations() != null) {
            sb.append("DhcpConfigurations: " + this.getDhcpConfigurations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDhcpOptionsRequest)) {
            return false;
        }
        CreateDhcpOptionsRequest other = (CreateDhcpOptionsRequest)obj;
        if (other.getDhcpConfigurations() == null ^ this.getDhcpConfigurations() == null) {
            return false;
        }
        return other.getDhcpConfigurations() == null || other.getDhcpConfigurations().equals(this.getDhcpConfigurations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDhcpConfigurations() == null ? 0 : this.getDhcpConfigurations().hashCode());
        return hashCode;
    }

    public CreateDhcpOptionsRequest clone() {
        return (CreateDhcpOptionsRequest)super.clone();
    }
}

