/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.IpPermission;
import com.amazonaws.services.ec2.model.transform.RevokeSecurityGroupEgressRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class RevokeSecurityGroupEgressRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<RevokeSecurityGroupEgressRequest> {
    private String groupId;
    private String sourceSecurityGroupName;
    private String sourceSecurityGroupOwnerId;
    private String ipProtocol;
    private Integer fromPort;
    private Integer toPort;
    private String cidrIp;
    private SdkInternalList<IpPermission> ipPermissions;

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public RevokeSecurityGroupEgressRequest withGroupId(String groupId) {
        this.setGroupId(groupId);
        return this;
    }

    public void setSourceSecurityGroupName(String sourceSecurityGroupName) {
        this.sourceSecurityGroupName = sourceSecurityGroupName;
    }

    public String getSourceSecurityGroupName() {
        return this.sourceSecurityGroupName;
    }

    public RevokeSecurityGroupEgressRequest withSourceSecurityGroupName(String sourceSecurityGroupName) {
        this.setSourceSecurityGroupName(sourceSecurityGroupName);
        return this;
    }

    public void setSourceSecurityGroupOwnerId(String sourceSecurityGroupOwnerId) {
        this.sourceSecurityGroupOwnerId = sourceSecurityGroupOwnerId;
    }

    public String getSourceSecurityGroupOwnerId() {
        return this.sourceSecurityGroupOwnerId;
    }

    public RevokeSecurityGroupEgressRequest withSourceSecurityGroupOwnerId(String sourceSecurityGroupOwnerId) {
        this.setSourceSecurityGroupOwnerId(sourceSecurityGroupOwnerId);
        return this;
    }

    public void setIpProtocol(String ipProtocol) {
        this.ipProtocol = ipProtocol;
    }

    public String getIpProtocol() {
        return this.ipProtocol;
    }

    public RevokeSecurityGroupEgressRequest withIpProtocol(String ipProtocol) {
        this.setIpProtocol(ipProtocol);
        return this;
    }

    public void setFromPort(Integer fromPort) {
        this.fromPort = fromPort;
    }

    public Integer getFromPort() {
        return this.fromPort;
    }

    public RevokeSecurityGroupEgressRequest withFromPort(Integer fromPort) {
        this.setFromPort(fromPort);
        return this;
    }

    public void setToPort(Integer toPort) {
        this.toPort = toPort;
    }

    public Integer getToPort() {
        return this.toPort;
    }

    public RevokeSecurityGroupEgressRequest withToPort(Integer toPort) {
        this.setToPort(toPort);
        return this;
    }

    public void setCidrIp(String cidrIp) {
        this.cidrIp = cidrIp;
    }

    public String getCidrIp() {
        return this.cidrIp;
    }

    public RevokeSecurityGroupEgressRequest withCidrIp(String cidrIp) {
        this.setCidrIp(cidrIp);
        return this;
    }

    public List<IpPermission> getIpPermissions() {
        if (this.ipPermissions == null) {
            this.ipPermissions = new SdkInternalList();
        }
        return this.ipPermissions;
    }

    public void setIpPermissions(Collection<IpPermission> ipPermissions) {
        if (ipPermissions == null) {
            this.ipPermissions = null;
            return;
        }
        this.ipPermissions = new SdkInternalList(ipPermissions);
    }

    public RevokeSecurityGroupEgressRequest withIpPermissions(IpPermission ... ipPermissions) {
        if (this.ipPermissions == null) {
            this.setIpPermissions((Collection<IpPermission>)new SdkInternalList(ipPermissions.length));
        }
        for (IpPermission ele : ipPermissions) {
            this.ipPermissions.add((Object)ele);
        }
        return this;
    }

    public RevokeSecurityGroupEgressRequest withIpPermissions(Collection<IpPermission> ipPermissions) {
        this.setIpPermissions(ipPermissions);
        return this;
    }

    @Override
    public Request<RevokeSecurityGroupEgressRequest> getDryRunRequest() {
        Request<RevokeSecurityGroupEgressRequest> request = new RevokeSecurityGroupEgressRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGroupId() != null) {
            sb.append("GroupId: " + this.getGroupId() + ",");
        }
        if (this.getSourceSecurityGroupName() != null) {
            sb.append("SourceSecurityGroupName: " + this.getSourceSecurityGroupName() + ",");
        }
        if (this.getSourceSecurityGroupOwnerId() != null) {
            sb.append("SourceSecurityGroupOwnerId: " + this.getSourceSecurityGroupOwnerId() + ",");
        }
        if (this.getIpProtocol() != null) {
            sb.append("IpProtocol: " + this.getIpProtocol() + ",");
        }
        if (this.getFromPort() != null) {
            sb.append("FromPort: " + this.getFromPort() + ",");
        }
        if (this.getToPort() != null) {
            sb.append("ToPort: " + this.getToPort() + ",");
        }
        if (this.getCidrIp() != null) {
            sb.append("CidrIp: " + this.getCidrIp() + ",");
        }
        if (this.getIpPermissions() != null) {
            sb.append("IpPermissions: " + this.getIpPermissions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevokeSecurityGroupEgressRequest)) {
            return false;
        }
        RevokeSecurityGroupEgressRequest other = (RevokeSecurityGroupEgressRequest)obj;
        if (other.getGroupId() == null ^ this.getGroupId() == null) {
            return false;
        }
        if (other.getGroupId() != null && !other.getGroupId().equals(this.getGroupId())) {
            return false;
        }
        if (other.getSourceSecurityGroupName() == null ^ this.getSourceSecurityGroupName() == null) {
            return false;
        }
        if (other.getSourceSecurityGroupName() != null && !other.getSourceSecurityGroupName().equals(this.getSourceSecurityGroupName())) {
            return false;
        }
        if (other.getSourceSecurityGroupOwnerId() == null ^ this.getSourceSecurityGroupOwnerId() == null) {
            return false;
        }
        if (other.getSourceSecurityGroupOwnerId() != null && !other.getSourceSecurityGroupOwnerId().equals(this.getSourceSecurityGroupOwnerId())) {
            return false;
        }
        if (other.getIpProtocol() == null ^ this.getIpProtocol() == null) {
            return false;
        }
        if (other.getIpProtocol() != null && !other.getIpProtocol().equals(this.getIpProtocol())) {
            return false;
        }
        if (other.getFromPort() == null ^ this.getFromPort() == null) {
            return false;
        }
        if (other.getFromPort() != null && !other.getFromPort().equals(this.getFromPort())) {
            return false;
        }
        if (other.getToPort() == null ^ this.getToPort() == null) {
            return false;
        }
        if (other.getToPort() != null && !other.getToPort().equals(this.getToPort())) {
            return false;
        }
        if (other.getCidrIp() == null ^ this.getCidrIp() == null) {
            return false;
        }
        if (other.getCidrIp() != null && !other.getCidrIp().equals(this.getCidrIp())) {
            return false;
        }
        if (other.getIpPermissions() == null ^ this.getIpPermissions() == null) {
            return false;
        }
        return other.getIpPermissions() == null || other.getIpPermissions().equals(this.getIpPermissions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGroupId() == null ? 0 : this.getGroupId().hashCode());
        hashCode = 31 * hashCode + (this.getSourceSecurityGroupName() == null ? 0 : this.getSourceSecurityGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getSourceSecurityGroupOwnerId() == null ? 0 : this.getSourceSecurityGroupOwnerId().hashCode());
        hashCode = 31 * hashCode + (this.getIpProtocol() == null ? 0 : this.getIpProtocol().hashCode());
        hashCode = 31 * hashCode + (this.getFromPort() == null ? 0 : this.getFromPort().hashCode());
        hashCode = 31 * hashCode + (this.getToPort() == null ? 0 : this.getToPort().hashCode());
        hashCode = 31 * hashCode + (this.getCidrIp() == null ? 0 : this.getCidrIp().hashCode());
        hashCode = 31 * hashCode + (this.getIpPermissions() == null ? 0 : this.getIpPermissions().hashCode());
        return hashCode;
    }

    public RevokeSecurityGroupEgressRequest clone() {
        return (RevokeSecurityGroupEgressRequest)super.clone();
    }
}

