/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeVpnGatewaysRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeVpnGatewaysRequestMarshaller
implements Marshaller<Request<DescribeVpnGatewaysRequest>, DescribeVpnGatewaysRequest> {
    public Request<DescribeVpnGatewaysRequest> marshall(DescribeVpnGatewaysRequest describeVpnGatewaysRequest) {
        SdkInternalList filtersList;
        if (describeVpnGatewaysRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeVpnGatewaysRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeVpnGateways");
        request.addParameter("Version", "2016-09-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList vpnGatewayIdsList = (SdkInternalList)describeVpnGatewaysRequest.getVpnGatewayIds();
        if (!vpnGatewayIdsList.isEmpty() || !vpnGatewayIdsList.isAutoConstruct()) {
            int vpnGatewayIdsListIndex = 1;
            for (String vpnGatewayIdsListValue : vpnGatewayIdsList) {
                if (vpnGatewayIdsListValue != null) {
                    request.addParameter("VpnGatewayId." + vpnGatewayIdsListIndex, StringUtils.fromString((String)vpnGatewayIdsListValue));
                }
                ++vpnGatewayIdsListIndex;
            }
        }
        if (!(filtersList = (SdkInternalList)describeVpnGatewaysRequest.getFilters()).isEmpty() || !filtersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                SdkInternalList valuesList;
                if (filtersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.getName()));
                }
                if (!(valuesList = (SdkInternalList)filtersListValue.getValues()).isEmpty() || !valuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        return request;
    }
}

