/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.ModifyReservedInstancesRequest;
import com.amazonaws.services.ec2.model.ReservedInstancesConfiguration;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyReservedInstancesRequestMarshaller
implements Marshaller<Request<ModifyReservedInstancesRequest>, ModifyReservedInstancesRequest> {
    public Request<ModifyReservedInstancesRequest> marshall(ModifyReservedInstancesRequest modifyReservedInstancesRequest) {
        SdkInternalList targetConfigurationsList;
        SdkInternalList reservedInstancesIdsList;
        if (modifyReservedInstancesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyReservedInstancesRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyReservedInstances");
        request.addParameter("Version", "2016-09-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyReservedInstancesRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)modifyReservedInstancesRequest.getClientToken()));
        }
        if (!(reservedInstancesIdsList = (SdkInternalList)modifyReservedInstancesRequest.getReservedInstancesIds()).isEmpty() || !reservedInstancesIdsList.isAutoConstruct()) {
            int reservedInstancesIdsListIndex = 1;
            for (String reservedInstancesIdsListValue : reservedInstancesIdsList) {
                if (reservedInstancesIdsListValue != null) {
                    request.addParameter("ReservedInstancesId." + reservedInstancesIdsListIndex, StringUtils.fromString((String)reservedInstancesIdsListValue));
                }
                ++reservedInstancesIdsListIndex;
            }
        }
        if (!(targetConfigurationsList = (SdkInternalList)modifyReservedInstancesRequest.getTargetConfigurations()).isEmpty() || !targetConfigurationsList.isAutoConstruct()) {
            int targetConfigurationsListIndex = 1;
            for (ReservedInstancesConfiguration targetConfigurationsListValue : targetConfigurationsList) {
                if (targetConfigurationsListValue.getAvailabilityZone() != null) {
                    request.addParameter("ReservedInstancesConfigurationSetItemType." + targetConfigurationsListIndex + ".AvailabilityZone", StringUtils.fromString((String)targetConfigurationsListValue.getAvailabilityZone()));
                }
                if (targetConfigurationsListValue.getPlatform() != null) {
                    request.addParameter("ReservedInstancesConfigurationSetItemType." + targetConfigurationsListIndex + ".Platform", StringUtils.fromString((String)targetConfigurationsListValue.getPlatform()));
                }
                if (targetConfigurationsListValue.getInstanceCount() != null) {
                    request.addParameter("ReservedInstancesConfigurationSetItemType." + targetConfigurationsListIndex + ".InstanceCount", StringUtils.fromInteger((Integer)targetConfigurationsListValue.getInstanceCount()));
                }
                if (targetConfigurationsListValue.getInstanceType() != null) {
                    request.addParameter("ReservedInstancesConfigurationSetItemType." + targetConfigurationsListIndex + ".InstanceType", StringUtils.fromString((String)targetConfigurationsListValue.getInstanceType()));
                }
                if (targetConfigurationsListValue.getScope() != null) {
                    request.addParameter("ReservedInstancesConfigurationSetItemType." + targetConfigurationsListIndex + ".Scope", StringUtils.fromString((String)targetConfigurationsListValue.getScope()));
                }
                ++targetConfigurationsListIndex;
            }
        }
        return request;
    }
}

