/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.CreateTransitGatewayRouteRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateTransitGatewayRouteRequestMarshaller
implements Marshaller<Request<CreateTransitGatewayRouteRequest>, CreateTransitGatewayRouteRequest> {
    public Request<CreateTransitGatewayRouteRequest> marshall(CreateTransitGatewayRouteRequest createTransitGatewayRouteRequest) {
        if (createTransitGatewayRouteRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createTransitGatewayRouteRequest, "AmazonEC2");
        request.addParameter("Action", "CreateTransitGatewayRoute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createTransitGatewayRouteRequest.getDestinationCidrBlock() != null) {
            request.addParameter("DestinationCidrBlock", StringUtils.fromString((String)createTransitGatewayRouteRequest.getDestinationCidrBlock()));
        }
        if (createTransitGatewayRouteRequest.getTransitGatewayRouteTableId() != null) {
            request.addParameter("TransitGatewayRouteTableId", StringUtils.fromString((String)createTransitGatewayRouteRequest.getTransitGatewayRouteTableId()));
        }
        if (createTransitGatewayRouteRequest.getTransitGatewayAttachmentId() != null) {
            request.addParameter("TransitGatewayAttachmentId", StringUtils.fromString((String)createTransitGatewayRouteRequest.getTransitGatewayAttachmentId()));
        }
        if (createTransitGatewayRouteRequest.getBlackhole() != null) {
            request.addParameter("Blackhole", StringUtils.fromBoolean((Boolean)createTransitGatewayRouteRequest.getBlackhole()));
        }
        return request;
    }
}

