/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CertificateAuthenticationRequest;
import com.amazonaws.services.ec2.model.ClientVpnAuthenticationRequest;
import com.amazonaws.services.ec2.model.ConnectionLogOptions;
import com.amazonaws.services.ec2.model.CreateClientVpnEndpointRequest;
import com.amazonaws.services.ec2.model.DirectoryServiceAuthenticationRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import com.amazonaws.util.StringUtils;

public class CreateClientVpnEndpointRequestMarshaller
implements Marshaller<Request<CreateClientVpnEndpointRequest>, CreateClientVpnEndpointRequest> {
    public Request<CreateClientVpnEndpointRequest> marshall(CreateClientVpnEndpointRequest createClientVpnEndpointRequest) {
        SdkInternalList createClientVpnEndpointRequestDnsServersList;
        ConnectionLogOptions connectionLogOptions;
        SdkInternalList createClientVpnEndpointRequestAuthenticationOptionsList;
        if (createClientVpnEndpointRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createClientVpnEndpointRequest, "AmazonEC2");
        request.addParameter("Action", "CreateClientVpnEndpoint");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createClientVpnEndpointRequest.getClientCidrBlock() != null) {
            request.addParameter("ClientCidrBlock", StringUtils.fromString((String)createClientVpnEndpointRequest.getClientCidrBlock()));
        }
        if (createClientVpnEndpointRequest.getServerCertificateArn() != null) {
            request.addParameter("ServerCertificateArn", StringUtils.fromString((String)createClientVpnEndpointRequest.getServerCertificateArn()));
        }
        if (!(createClientVpnEndpointRequestAuthenticationOptionsList = (SdkInternalList)createClientVpnEndpointRequest.getAuthenticationOptions()).isEmpty() || !createClientVpnEndpointRequestAuthenticationOptionsList.isAutoConstruct()) {
            int authenticationOptionsListIndex = 1;
            for (ClientVpnAuthenticationRequest createClientVpnEndpointRequestAuthenticationOptionsListValue : createClientVpnEndpointRequestAuthenticationOptionsList) {
                CertificateAuthenticationRequest mutualAuthentication;
                Object activeDirectory;
                if (createClientVpnEndpointRequestAuthenticationOptionsListValue.getType() != null) {
                    request.addParameter("Authentication." + authenticationOptionsListIndex + ".Type", StringUtils.fromString((String)createClientVpnEndpointRequestAuthenticationOptionsListValue.getType()));
                }
                if ((activeDirectory = createClientVpnEndpointRequestAuthenticationOptionsListValue.getActiveDirectory()) != null && ((DirectoryServiceAuthenticationRequest)activeDirectory).getDirectoryId() != null) {
                    request.addParameter("Authentication." + authenticationOptionsListIndex + ".ActiveDirectory.DirectoryId", StringUtils.fromString((String)((DirectoryServiceAuthenticationRequest)activeDirectory).getDirectoryId()));
                }
                if ((mutualAuthentication = createClientVpnEndpointRequestAuthenticationOptionsListValue.getMutualAuthentication()) != null && mutualAuthentication.getClientRootCertificateChainArn() != null) {
                    request.addParameter("Authentication." + authenticationOptionsListIndex + ".MutualAuthentication.ClientRootCertificateChainArn", StringUtils.fromString((String)mutualAuthentication.getClientRootCertificateChainArn()));
                }
                ++authenticationOptionsListIndex;
            }
        }
        if ((connectionLogOptions = createClientVpnEndpointRequest.getConnectionLogOptions()) != null) {
            if (connectionLogOptions.getEnabled() != null) {
                request.addParameter("ConnectionLogOptions.Enabled", StringUtils.fromBoolean((Boolean)connectionLogOptions.getEnabled()));
            }
            if (connectionLogOptions.getCloudwatchLogGroup() != null) {
                request.addParameter("ConnectionLogOptions.CloudwatchLogGroup", StringUtils.fromString((String)connectionLogOptions.getCloudwatchLogGroup()));
            }
            if (connectionLogOptions.getCloudwatchLogStream() != null) {
                request.addParameter("ConnectionLogOptions.CloudwatchLogStream", StringUtils.fromString((String)connectionLogOptions.getCloudwatchLogStream()));
            }
        }
        if (!(createClientVpnEndpointRequestDnsServersList = (SdkInternalList)createClientVpnEndpointRequest.getDnsServers()).isEmpty() || !createClientVpnEndpointRequestDnsServersList.isAutoConstruct()) {
            int dnsServersListIndex = 1;
            for (String createClientVpnEndpointRequestDnsServersListValue : createClientVpnEndpointRequestDnsServersList) {
                if (createClientVpnEndpointRequestDnsServersListValue != null) {
                    request.addParameter("DnsServers." + dnsServersListIndex, StringUtils.fromString((String)createClientVpnEndpointRequestDnsServersListValue));
                }
                ++dnsServersListIndex;
            }
        }
        if (createClientVpnEndpointRequest.getTransportProtocol() != null) {
            request.addParameter("TransportProtocol", StringUtils.fromString((String)createClientVpnEndpointRequest.getTransportProtocol()));
        }
        if (createClientVpnEndpointRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createClientVpnEndpointRequest.getDescription()));
        }
        request.addParameter("ClientToken", IdempotentUtils.resolveString((String)createClientVpnEndpointRequest.getClientToken()));
        SdkInternalList createClientVpnEndpointRequestTagSpecificationsList = (SdkInternalList)createClientVpnEndpointRequest.getTagSpecifications();
        if (!createClientVpnEndpointRequestTagSpecificationsList.isEmpty() || !createClientVpnEndpointRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createClientVpnEndpointRequestTagSpecificationsListValue : createClientVpnEndpointRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createClientVpnEndpointRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)createClientVpnEndpointRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createClientVpnEndpointRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        return request;
    }
}

