/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.FleetExcessCapacityTerminationPolicy;
import com.amazonaws.services.ec2.model.FleetLaunchTemplateConfigRequest;
import com.amazonaws.services.ec2.model.FleetType;
import com.amazonaws.services.ec2.model.OnDemandOptionsRequest;
import com.amazonaws.services.ec2.model.SpotOptionsRequest;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.services.ec2.model.TargetCapacitySpecificationRequest;
import com.amazonaws.services.ec2.model.transform.CreateFleetRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class CreateFleetRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<CreateFleetRequest> {
    private String clientToken;
    private SpotOptionsRequest spotOptions;
    private OnDemandOptionsRequest onDemandOptions;
    private String excessCapacityTerminationPolicy;
    private SdkInternalList<FleetLaunchTemplateConfigRequest> launchTemplateConfigs;
    private TargetCapacitySpecificationRequest targetCapacitySpecification;
    private Boolean terminateInstancesWithExpiration;
    private String type;
    private Date validFrom;
    private Date validUntil;
    private Boolean replaceUnhealthyInstances;
    private SdkInternalList<TagSpecification> tagSpecifications;

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateFleetRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setSpotOptions(SpotOptionsRequest spotOptions) {
        this.spotOptions = spotOptions;
    }

    public SpotOptionsRequest getSpotOptions() {
        return this.spotOptions;
    }

    public CreateFleetRequest withSpotOptions(SpotOptionsRequest spotOptions) {
        this.setSpotOptions(spotOptions);
        return this;
    }

    public void setOnDemandOptions(OnDemandOptionsRequest onDemandOptions) {
        this.onDemandOptions = onDemandOptions;
    }

    public OnDemandOptionsRequest getOnDemandOptions() {
        return this.onDemandOptions;
    }

    public CreateFleetRequest withOnDemandOptions(OnDemandOptionsRequest onDemandOptions) {
        this.setOnDemandOptions(onDemandOptions);
        return this;
    }

    public void setExcessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
        this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
    }

    public String getExcessCapacityTerminationPolicy() {
        return this.excessCapacityTerminationPolicy;
    }

    public CreateFleetRequest withExcessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
        this.setExcessCapacityTerminationPolicy(excessCapacityTerminationPolicy);
        return this;
    }

    public CreateFleetRequest withExcessCapacityTerminationPolicy(FleetExcessCapacityTerminationPolicy excessCapacityTerminationPolicy) {
        this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy.toString();
        return this;
    }

    public List<FleetLaunchTemplateConfigRequest> getLaunchTemplateConfigs() {
        if (this.launchTemplateConfigs == null) {
            this.launchTemplateConfigs = new SdkInternalList();
        }
        return this.launchTemplateConfigs;
    }

    public void setLaunchTemplateConfigs(Collection<FleetLaunchTemplateConfigRequest> launchTemplateConfigs) {
        if (launchTemplateConfigs == null) {
            this.launchTemplateConfigs = null;
            return;
        }
        this.launchTemplateConfigs = new SdkInternalList(launchTemplateConfigs);
    }

    public CreateFleetRequest withLaunchTemplateConfigs(FleetLaunchTemplateConfigRequest ... launchTemplateConfigs) {
        if (this.launchTemplateConfigs == null) {
            this.setLaunchTemplateConfigs((Collection<FleetLaunchTemplateConfigRequest>)new SdkInternalList(launchTemplateConfigs.length));
        }
        for (FleetLaunchTemplateConfigRequest ele : launchTemplateConfigs) {
            this.launchTemplateConfigs.add((Object)ele);
        }
        return this;
    }

    public CreateFleetRequest withLaunchTemplateConfigs(Collection<FleetLaunchTemplateConfigRequest> launchTemplateConfigs) {
        this.setLaunchTemplateConfigs(launchTemplateConfigs);
        return this;
    }

    public void setTargetCapacitySpecification(TargetCapacitySpecificationRequest targetCapacitySpecification) {
        this.targetCapacitySpecification = targetCapacitySpecification;
    }

    public TargetCapacitySpecificationRequest getTargetCapacitySpecification() {
        return this.targetCapacitySpecification;
    }

    public CreateFleetRequest withTargetCapacitySpecification(TargetCapacitySpecificationRequest targetCapacitySpecification) {
        this.setTargetCapacitySpecification(targetCapacitySpecification);
        return this;
    }

    public void setTerminateInstancesWithExpiration(Boolean terminateInstancesWithExpiration) {
        this.terminateInstancesWithExpiration = terminateInstancesWithExpiration;
    }

    public Boolean getTerminateInstancesWithExpiration() {
        return this.terminateInstancesWithExpiration;
    }

    public CreateFleetRequest withTerminateInstancesWithExpiration(Boolean terminateInstancesWithExpiration) {
        this.setTerminateInstancesWithExpiration(terminateInstancesWithExpiration);
        return this;
    }

    public Boolean isTerminateInstancesWithExpiration() {
        return this.terminateInstancesWithExpiration;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public CreateFleetRequest withType(String type) {
        this.setType(type);
        return this;
    }

    public CreateFleetRequest withType(FleetType type) {
        this.type = type.toString();
        return this;
    }

    public void setValidFrom(Date validFrom) {
        this.validFrom = validFrom;
    }

    public Date getValidFrom() {
        return this.validFrom;
    }

    public CreateFleetRequest withValidFrom(Date validFrom) {
        this.setValidFrom(validFrom);
        return this;
    }

    public void setValidUntil(Date validUntil) {
        this.validUntil = validUntil;
    }

    public Date getValidUntil() {
        return this.validUntil;
    }

    public CreateFleetRequest withValidUntil(Date validUntil) {
        this.setValidUntil(validUntil);
        return this;
    }

    public void setReplaceUnhealthyInstances(Boolean replaceUnhealthyInstances) {
        this.replaceUnhealthyInstances = replaceUnhealthyInstances;
    }

    public Boolean getReplaceUnhealthyInstances() {
        return this.replaceUnhealthyInstances;
    }

    public CreateFleetRequest withReplaceUnhealthyInstances(Boolean replaceUnhealthyInstances) {
        this.setReplaceUnhealthyInstances(replaceUnhealthyInstances);
        return this;
    }

    public Boolean isReplaceUnhealthyInstances() {
        return this.replaceUnhealthyInstances;
    }

    public List<TagSpecification> getTagSpecifications() {
        if (this.tagSpecifications == null) {
            this.tagSpecifications = new SdkInternalList();
        }
        return this.tagSpecifications;
    }

    public void setTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        if (tagSpecifications == null) {
            this.tagSpecifications = null;
            return;
        }
        this.tagSpecifications = new SdkInternalList(tagSpecifications);
    }

    public CreateFleetRequest withTagSpecifications(TagSpecification ... tagSpecifications) {
        if (this.tagSpecifications == null) {
            this.setTagSpecifications((Collection<TagSpecification>)new SdkInternalList(tagSpecifications.length));
        }
        for (TagSpecification ele : tagSpecifications) {
            this.tagSpecifications.add((Object)ele);
        }
        return this;
    }

    public CreateFleetRequest withTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        this.setTagSpecifications(tagSpecifications);
        return this;
    }

    @Override
    public Request<CreateFleetRequest> getDryRunRequest() {
        Request<CreateFleetRequest> request = new CreateFleetRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getSpotOptions() != null) {
            sb.append("SpotOptions: ").append(this.getSpotOptions()).append(",");
        }
        if (this.getOnDemandOptions() != null) {
            sb.append("OnDemandOptions: ").append(this.getOnDemandOptions()).append(",");
        }
        if (this.getExcessCapacityTerminationPolicy() != null) {
            sb.append("ExcessCapacityTerminationPolicy: ").append(this.getExcessCapacityTerminationPolicy()).append(",");
        }
        if (this.getLaunchTemplateConfigs() != null) {
            sb.append("LaunchTemplateConfigs: ").append(this.getLaunchTemplateConfigs()).append(",");
        }
        if (this.getTargetCapacitySpecification() != null) {
            sb.append("TargetCapacitySpecification: ").append(this.getTargetCapacitySpecification()).append(",");
        }
        if (this.getTerminateInstancesWithExpiration() != null) {
            sb.append("TerminateInstancesWithExpiration: ").append(this.getTerminateInstancesWithExpiration()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getValidFrom() != null) {
            sb.append("ValidFrom: ").append(this.getValidFrom()).append(",");
        }
        if (this.getValidUntil() != null) {
            sb.append("ValidUntil: ").append(this.getValidUntil()).append(",");
        }
        if (this.getReplaceUnhealthyInstances() != null) {
            sb.append("ReplaceUnhealthyInstances: ").append(this.getReplaceUnhealthyInstances()).append(",");
        }
        if (this.getTagSpecifications() != null) {
            sb.append("TagSpecifications: ").append(this.getTagSpecifications());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFleetRequest)) {
            return false;
        }
        CreateFleetRequest other = (CreateFleetRequest)obj;
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getSpotOptions() == null ^ this.getSpotOptions() == null) {
            return false;
        }
        if (other.getSpotOptions() != null && !other.getSpotOptions().equals(this.getSpotOptions())) {
            return false;
        }
        if (other.getOnDemandOptions() == null ^ this.getOnDemandOptions() == null) {
            return false;
        }
        if (other.getOnDemandOptions() != null && !other.getOnDemandOptions().equals(this.getOnDemandOptions())) {
            return false;
        }
        if (other.getExcessCapacityTerminationPolicy() == null ^ this.getExcessCapacityTerminationPolicy() == null) {
            return false;
        }
        if (other.getExcessCapacityTerminationPolicy() != null && !other.getExcessCapacityTerminationPolicy().equals(this.getExcessCapacityTerminationPolicy())) {
            return false;
        }
        if (other.getLaunchTemplateConfigs() == null ^ this.getLaunchTemplateConfigs() == null) {
            return false;
        }
        if (other.getLaunchTemplateConfigs() != null && !other.getLaunchTemplateConfigs().equals(this.getLaunchTemplateConfigs())) {
            return false;
        }
        if (other.getTargetCapacitySpecification() == null ^ this.getTargetCapacitySpecification() == null) {
            return false;
        }
        if (other.getTargetCapacitySpecification() != null && !other.getTargetCapacitySpecification().equals(this.getTargetCapacitySpecification())) {
            return false;
        }
        if (other.getTerminateInstancesWithExpiration() == null ^ this.getTerminateInstancesWithExpiration() == null) {
            return false;
        }
        if (other.getTerminateInstancesWithExpiration() != null && !other.getTerminateInstancesWithExpiration().equals(this.getTerminateInstancesWithExpiration())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getValidFrom() == null ^ this.getValidFrom() == null) {
            return false;
        }
        if (other.getValidFrom() != null && !other.getValidFrom().equals(this.getValidFrom())) {
            return false;
        }
        if (other.getValidUntil() == null ^ this.getValidUntil() == null) {
            return false;
        }
        if (other.getValidUntil() != null && !other.getValidUntil().equals(this.getValidUntil())) {
            return false;
        }
        if (other.getReplaceUnhealthyInstances() == null ^ this.getReplaceUnhealthyInstances() == null) {
            return false;
        }
        if (other.getReplaceUnhealthyInstances() != null && !other.getReplaceUnhealthyInstances().equals(this.getReplaceUnhealthyInstances())) {
            return false;
        }
        if (other.getTagSpecifications() == null ^ this.getTagSpecifications() == null) {
            return false;
        }
        return other.getTagSpecifications() == null || other.getTagSpecifications().equals(this.getTagSpecifications());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getSpotOptions() == null ? 0 : this.getSpotOptions().hashCode());
        hashCode = 31 * hashCode + (this.getOnDemandOptions() == null ? 0 : this.getOnDemandOptions().hashCode());
        hashCode = 31 * hashCode + (this.getExcessCapacityTerminationPolicy() == null ? 0 : this.getExcessCapacityTerminationPolicy().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchTemplateConfigs() == null ? 0 : this.getLaunchTemplateConfigs().hashCode());
        hashCode = 31 * hashCode + (this.getTargetCapacitySpecification() == null ? 0 : this.getTargetCapacitySpecification().hashCode());
        hashCode = 31 * hashCode + (this.getTerminateInstancesWithExpiration() == null ? 0 : this.getTerminateInstancesWithExpiration().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getValidFrom() == null ? 0 : this.getValidFrom().hashCode());
        hashCode = 31 * hashCode + (this.getValidUntil() == null ? 0 : this.getValidUntil().hashCode());
        hashCode = 31 * hashCode + (this.getReplaceUnhealthyInstances() == null ? 0 : this.getReplaceUnhealthyInstances().hashCode());
        hashCode = 31 * hashCode + (this.getTagSpecifications() == null ? 0 : this.getTagSpecifications().hashCode());
        return hashCode;
    }

    public CreateFleetRequest clone() {
        return (CreateFleetRequest)super.clone();
    }
}

