/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.CoipPool;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.transform.TagStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class CoipPoolStaxUnmarshaller
implements Unmarshaller<CoipPool, StaxUnmarshallerContext> {
    private static CoipPoolStaxUnmarshaller instance;

    public CoipPool unmarshall(StaxUnmarshallerContext context) throws Exception {
        CoipPool coipPool = new CoipPool();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return coipPool;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("poolId", targetDepth)) {
                    coipPool.setPoolId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("poolCidrSet", targetDepth)) {
                    coipPool.withPoolCidrs(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("poolCidrSet/item", targetDepth)) {
                    coipPool.withPoolCidrs(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("localGatewayRouteTableId", targetDepth)) {
                    coipPool.setLocalGatewayRouteTableId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("tagSet", targetDepth)) {
                    coipPool.withTags(new ArrayList<Tag>());
                    continue;
                }
                if (!context.testExpression("tagSet/item", targetDepth)) continue;
                coipPool.withTags(TagStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return coipPool;
    }

    public static CoipPoolStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new CoipPoolStaxUnmarshaller();
        }
        return instance;
    }
}

