/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.GetCoipPoolUsageRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class GetCoipPoolUsageRequestMarshaller
implements Marshaller<Request<GetCoipPoolUsageRequest>, GetCoipPoolUsageRequest> {
    public Request<GetCoipPoolUsageRequest> marshall(GetCoipPoolUsageRequest getCoipPoolUsageRequest) {
        SdkInternalList getCoipPoolUsageRequestFiltersList;
        if (getCoipPoolUsageRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getCoipPoolUsageRequest, "AmazonEC2");
        request.addParameter("Action", "GetCoipPoolUsage");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (getCoipPoolUsageRequest.getPoolId() != null) {
            request.addParameter("PoolId", StringUtils.fromString((String)getCoipPoolUsageRequest.getPoolId()));
        }
        if (!(getCoipPoolUsageRequestFiltersList = (SdkInternalList)getCoipPoolUsageRequest.getFilters()).isEmpty() || !getCoipPoolUsageRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter getCoipPoolUsageRequestFiltersListValue : getCoipPoolUsageRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (getCoipPoolUsageRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)getCoipPoolUsageRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)getCoipPoolUsageRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (getCoipPoolUsageRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)getCoipPoolUsageRequest.getMaxResults()));
        }
        if (getCoipPoolUsageRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)getCoipPoolUsageRequest.getNextToken()));
        }
        return request;
    }
}

