/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.IKEVersionsRequestListValue;
import com.amazonaws.services.ec2.model.ModifyVpnTunnelOptionsRequest;
import com.amazonaws.services.ec2.model.ModifyVpnTunnelOptionsSpecification;
import com.amazonaws.services.ec2.model.Phase1DHGroupNumbersRequestListValue;
import com.amazonaws.services.ec2.model.Phase1EncryptionAlgorithmsRequestListValue;
import com.amazonaws.services.ec2.model.Phase1IntegrityAlgorithmsRequestListValue;
import com.amazonaws.services.ec2.model.Phase2DHGroupNumbersRequestListValue;
import com.amazonaws.services.ec2.model.Phase2EncryptionAlgorithmsRequestListValue;
import com.amazonaws.services.ec2.model.Phase2IntegrityAlgorithmsRequestListValue;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyVpnTunnelOptionsRequestMarshaller
implements Marshaller<Request<ModifyVpnTunnelOptionsRequest>, ModifyVpnTunnelOptionsRequest> {
    public Request<ModifyVpnTunnelOptionsRequest> marshall(ModifyVpnTunnelOptionsRequest modifyVpnTunnelOptionsRequest) {
        ModifyVpnTunnelOptionsSpecification tunnelOptions;
        if (modifyVpnTunnelOptionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyVpnTunnelOptionsRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyVpnTunnelOptions");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyVpnTunnelOptionsRequest.getVpnConnectionId() != null) {
            request.addParameter("VpnConnectionId", StringUtils.fromString((String)modifyVpnTunnelOptionsRequest.getVpnConnectionId()));
        }
        if (modifyVpnTunnelOptionsRequest.getVpnTunnelOutsideIpAddress() != null) {
            request.addParameter("VpnTunnelOutsideIpAddress", StringUtils.fromString((String)modifyVpnTunnelOptionsRequest.getVpnTunnelOutsideIpAddress()));
        }
        if ((tunnelOptions = modifyVpnTunnelOptionsRequest.getTunnelOptions()) != null) {
            SdkInternalList modifyVpnTunnelOptionsSpecificationIKEVersionsList;
            SdkInternalList modifyVpnTunnelOptionsSpecificationPhase2DHGroupNumbersList;
            SdkInternalList modifyVpnTunnelOptionsSpecificationPhase1DHGroupNumbersList;
            SdkInternalList modifyVpnTunnelOptionsSpecificationPhase2IntegrityAlgorithmsList;
            SdkInternalList modifyVpnTunnelOptionsSpecificationPhase1IntegrityAlgorithmsList;
            SdkInternalList modifyVpnTunnelOptionsSpecificationPhase2EncryptionAlgorithmsList;
            SdkInternalList modifyVpnTunnelOptionsSpecificationPhase1EncryptionAlgorithmsList;
            if (tunnelOptions.getTunnelInsideCidr() != null) {
                request.addParameter("TunnelOptions.TunnelInsideCidr", StringUtils.fromString((String)tunnelOptions.getTunnelInsideCidr()));
            }
            if (tunnelOptions.getPreSharedKey() != null) {
                request.addParameter("TunnelOptions.PreSharedKey", StringUtils.fromString((String)tunnelOptions.getPreSharedKey()));
            }
            if (tunnelOptions.getPhase1LifetimeSeconds() != null) {
                request.addParameter("TunnelOptions.Phase1LifetimeSeconds", StringUtils.fromInteger((Integer)tunnelOptions.getPhase1LifetimeSeconds()));
            }
            if (tunnelOptions.getPhase2LifetimeSeconds() != null) {
                request.addParameter("TunnelOptions.Phase2LifetimeSeconds", StringUtils.fromInteger((Integer)tunnelOptions.getPhase2LifetimeSeconds()));
            }
            if (tunnelOptions.getRekeyMarginTimeSeconds() != null) {
                request.addParameter("TunnelOptions.RekeyMarginTimeSeconds", StringUtils.fromInteger((Integer)tunnelOptions.getRekeyMarginTimeSeconds()));
            }
            if (tunnelOptions.getRekeyFuzzPercentage() != null) {
                request.addParameter("TunnelOptions.RekeyFuzzPercentage", StringUtils.fromInteger((Integer)tunnelOptions.getRekeyFuzzPercentage()));
            }
            if (tunnelOptions.getReplayWindowSize() != null) {
                request.addParameter("TunnelOptions.ReplayWindowSize", StringUtils.fromInteger((Integer)tunnelOptions.getReplayWindowSize()));
            }
            if (tunnelOptions.getDPDTimeoutSeconds() != null) {
                request.addParameter("TunnelOptions.DPDTimeoutSeconds", StringUtils.fromInteger((Integer)tunnelOptions.getDPDTimeoutSeconds()));
            }
            if (!(modifyVpnTunnelOptionsSpecificationPhase1EncryptionAlgorithmsList = (SdkInternalList)tunnelOptions.getPhase1EncryptionAlgorithms()).isEmpty() || !modifyVpnTunnelOptionsSpecificationPhase1EncryptionAlgorithmsList.isAutoConstruct()) {
                int phase1EncryptionAlgorithmsListIndex = 1;
                for (Object modifyVpnTunnelOptionsSpecificationPhase1EncryptionAlgorithmsListValue : modifyVpnTunnelOptionsSpecificationPhase1EncryptionAlgorithmsList) {
                    if (((Phase1EncryptionAlgorithmsRequestListValue)modifyVpnTunnelOptionsSpecificationPhase1EncryptionAlgorithmsListValue).getValue() != null) {
                        request.addParameter("TunnelOptions.Phase1EncryptionAlgorithm." + phase1EncryptionAlgorithmsListIndex + ".Value", StringUtils.fromString((String)((Phase1EncryptionAlgorithmsRequestListValue)modifyVpnTunnelOptionsSpecificationPhase1EncryptionAlgorithmsListValue).getValue()));
                    }
                    ++phase1EncryptionAlgorithmsListIndex;
                }
            }
            if (!(modifyVpnTunnelOptionsSpecificationPhase2EncryptionAlgorithmsList = (SdkInternalList)tunnelOptions.getPhase2EncryptionAlgorithms()).isEmpty() || !modifyVpnTunnelOptionsSpecificationPhase2EncryptionAlgorithmsList.isAutoConstruct()) {
                int phase2EncryptionAlgorithmsListIndex = 1;
                for (Object modifyVpnTunnelOptionsSpecificationPhase2EncryptionAlgorithmsListValue : modifyVpnTunnelOptionsSpecificationPhase2EncryptionAlgorithmsList) {
                    if (((Phase2EncryptionAlgorithmsRequestListValue)modifyVpnTunnelOptionsSpecificationPhase2EncryptionAlgorithmsListValue).getValue() != null) {
                        request.addParameter("TunnelOptions.Phase2EncryptionAlgorithm." + phase2EncryptionAlgorithmsListIndex + ".Value", StringUtils.fromString((String)((Phase2EncryptionAlgorithmsRequestListValue)modifyVpnTunnelOptionsSpecificationPhase2EncryptionAlgorithmsListValue).getValue()));
                    }
                    ++phase2EncryptionAlgorithmsListIndex;
                }
            }
            if (!(modifyVpnTunnelOptionsSpecificationPhase1IntegrityAlgorithmsList = (SdkInternalList)tunnelOptions.getPhase1IntegrityAlgorithms()).isEmpty() || !modifyVpnTunnelOptionsSpecificationPhase1IntegrityAlgorithmsList.isAutoConstruct()) {
                int phase1IntegrityAlgorithmsListIndex = 1;
                for (Object modifyVpnTunnelOptionsSpecificationPhase1IntegrityAlgorithmsListValue : modifyVpnTunnelOptionsSpecificationPhase1IntegrityAlgorithmsList) {
                    if (((Phase1IntegrityAlgorithmsRequestListValue)modifyVpnTunnelOptionsSpecificationPhase1IntegrityAlgorithmsListValue).getValue() != null) {
                        request.addParameter("TunnelOptions.Phase1IntegrityAlgorithm." + phase1IntegrityAlgorithmsListIndex + ".Value", StringUtils.fromString((String)((Phase1IntegrityAlgorithmsRequestListValue)modifyVpnTunnelOptionsSpecificationPhase1IntegrityAlgorithmsListValue).getValue()));
                    }
                    ++phase1IntegrityAlgorithmsListIndex;
                }
            }
            if (!(modifyVpnTunnelOptionsSpecificationPhase2IntegrityAlgorithmsList = (SdkInternalList)tunnelOptions.getPhase2IntegrityAlgorithms()).isEmpty() || !modifyVpnTunnelOptionsSpecificationPhase2IntegrityAlgorithmsList.isAutoConstruct()) {
                int phase2IntegrityAlgorithmsListIndex = 1;
                for (Object modifyVpnTunnelOptionsSpecificationPhase2IntegrityAlgorithmsListValue : modifyVpnTunnelOptionsSpecificationPhase2IntegrityAlgorithmsList) {
                    if (((Phase2IntegrityAlgorithmsRequestListValue)modifyVpnTunnelOptionsSpecificationPhase2IntegrityAlgorithmsListValue).getValue() != null) {
                        request.addParameter("TunnelOptions.Phase2IntegrityAlgorithm." + phase2IntegrityAlgorithmsListIndex + ".Value", StringUtils.fromString((String)((Phase2IntegrityAlgorithmsRequestListValue)modifyVpnTunnelOptionsSpecificationPhase2IntegrityAlgorithmsListValue).getValue()));
                    }
                    ++phase2IntegrityAlgorithmsListIndex;
                }
            }
            if (!(modifyVpnTunnelOptionsSpecificationPhase1DHGroupNumbersList = (SdkInternalList)tunnelOptions.getPhase1DHGroupNumbers()).isEmpty() || !modifyVpnTunnelOptionsSpecificationPhase1DHGroupNumbersList.isAutoConstruct()) {
                int phase1DHGroupNumbersListIndex = 1;
                for (Object modifyVpnTunnelOptionsSpecificationPhase1DHGroupNumbersListValue : modifyVpnTunnelOptionsSpecificationPhase1DHGroupNumbersList) {
                    if (((Phase1DHGroupNumbersRequestListValue)modifyVpnTunnelOptionsSpecificationPhase1DHGroupNumbersListValue).getValue() != null) {
                        request.addParameter("TunnelOptions.Phase1DHGroupNumber." + phase1DHGroupNumbersListIndex + ".Value", StringUtils.fromInteger((Integer)((Phase1DHGroupNumbersRequestListValue)modifyVpnTunnelOptionsSpecificationPhase1DHGroupNumbersListValue).getValue()));
                    }
                    ++phase1DHGroupNumbersListIndex;
                }
            }
            if (!(modifyVpnTunnelOptionsSpecificationPhase2DHGroupNumbersList = (SdkInternalList)tunnelOptions.getPhase2DHGroupNumbers()).isEmpty() || !modifyVpnTunnelOptionsSpecificationPhase2DHGroupNumbersList.isAutoConstruct()) {
                int phase2DHGroupNumbersListIndex = 1;
                for (Phase2DHGroupNumbersRequestListValue modifyVpnTunnelOptionsSpecificationPhase2DHGroupNumbersListValue : modifyVpnTunnelOptionsSpecificationPhase2DHGroupNumbersList) {
                    if (modifyVpnTunnelOptionsSpecificationPhase2DHGroupNumbersListValue.getValue() != null) {
                        request.addParameter("TunnelOptions.Phase2DHGroupNumber." + phase2DHGroupNumbersListIndex + ".Value", StringUtils.fromInteger((Integer)modifyVpnTunnelOptionsSpecificationPhase2DHGroupNumbersListValue.getValue()));
                    }
                    ++phase2DHGroupNumbersListIndex;
                }
            }
            if (!(modifyVpnTunnelOptionsSpecificationIKEVersionsList = (SdkInternalList)tunnelOptions.getIKEVersions()).isEmpty() || !modifyVpnTunnelOptionsSpecificationIKEVersionsList.isAutoConstruct()) {
                int iKEVersionsListIndex = 1;
                for (IKEVersionsRequestListValue modifyVpnTunnelOptionsSpecificationIKEVersionsListValue : modifyVpnTunnelOptionsSpecificationIKEVersionsList) {
                    if (modifyVpnTunnelOptionsSpecificationIKEVersionsListValue.getValue() != null) {
                        request.addParameter("TunnelOptions.IKEVersion." + iKEVersionsListIndex + ".Value", StringUtils.fromString((String)modifyVpnTunnelOptionsSpecificationIKEVersionsListValue.getValue()));
                    }
                    ++iKEVersionsListIndex;
                }
            }
        }
        return request;
    }
}

